/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

public class SetThreadName
implements AutoCloseable {
    private static ThreadLocal<SetThreadName> thSetName = new ThreadLocal();
    private String originName;
    private String startName;

    public static void start() {
        SetThreadName origin = thSetName.get();
        if (origin != null) {
            origin.close();
        }
        thSetName.set(new SetThreadName());
    }

    public static void end() {
        SetThreadName setName = thSetName.get();
        if (setName != null) {
            setName.close();
        }
    }

    public SetThreadName() {
        this.init();
    }

    public void init() {
        this.originName = Thread.currentThread().getName();
        this.startName = this.originName + "//time:" + System.currentTimeMillis();
        Thread.currentThread().setName(this.startName);
    }

    @Override
    public void close() {
        Thread.currentThread().setName(this.originName);
    }

    public static void setTraceId(String traceId) {
        SetThreadName tn = thSetName.get();
        if (tn != null) {
            String newName = tn.startName.replace("//", "/traceId:" + traceId + "/");
            Thread.currentThread().setName(newName);
        }
    }
}

