/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.bundle.Resources;
import kd.bos.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(DiskCacheUtils.class);
    private static final String dataFileSuffix = ".diskCache.data";
    private static final String timeFileSuffix = ".diskCache.meta";
    private static final String timeoutKey = "timeout";
    private static final String cacheKey = "cacheKey";
    private static final String diskCachePath = "diskcache.path";

    @Deprecated
    public static void cacheData(String key, InputStream inputStream, int timeoutSecond) {
        String dataFileUrl = DiskCacheUtils.getDataFileUrl(key);
        DiskCacheUtils.writeToFile(dataFileUrl, inputStream);
        DiskCacheUtils.createTimeMetaProp(key, timeoutSecond);
    }

    @Deprecated
    public static OutputStream cacheOutputStream(String key, int timeoutSecond) {
        String dataFileUrl = DiskCacheUtils.getDataFileUrl(key);
        OutputStream out2 = DiskCacheUtils.getOutPutStream(dataFileUrl);
        DiskCacheUtils.createTimeMetaProp(key, timeoutSecond);
        return out2;
    }

    public static void cacheData(String key, InputStream inputStream) {
        String dataFileUrl = DiskCacheUtils.getDataFileUrl(key);
        DiskCacheUtils.writeToFile(dataFileUrl, inputStream);
    }

    public static OutputStream cacheOutputStream(String key) {
        String dataFileUrl = DiskCacheUtils.getDataFileUrl(key);
        OutputStream out2 = DiskCacheUtils.getOutPutStream(dataFileUrl);
        return out2;
    }

    public static void setTimeout(String key, int timeoutSecond) {
        DiskCacheUtils.createTimeMetaProp(key, timeoutSecond);
    }

    public static InputStream getData(String key) {
        String dataFileUrl = DiskCacheUtils.getDataFileUrl(key);
        return DiskCacheUtils.getInputStream(dataFileUrl);
    }

    public static boolean exists(String key) {
        String fileUrl = DiskCacheUtils.getDataFileUrl(key);
        File file = new File(fileUrl);
        return file.exists();
    }

    public static boolean remove(String key) {
        String dataFileUrl = DiskCacheUtils.getDataFileUrl(key);
        String timeFileUrl = DiskCacheUtils.getTimeFileUrl(key);
        return DiskCacheUtils.delete(dataFileUrl) && DiskCacheUtils.delete(timeFileUrl);
    }

    public static boolean removeSamePrefixKeys(String prefix) {
        return DiskCacheUtils.clearSamePrefixKeys(prefix);
    }

    private static void clearTimeoutKeys() {
        String path = DiskCacheUtils.getDiskCachePath();
        File fileDir = new File(path);
        if (fileDir.isDirectory()) {
            File[] fileDirs;
            for (File fileDirItem : fileDirs = fileDir.listFiles()) {
                if (!fileDirItem.isDirectory()) continue;
                for (File fileItem : fileDirItem.listFiles()) {
                    if (!fileItem.isFile() || !fileItem.getName().endsWith(timeFileSuffix)) continue;
                    try (FileInputStream fis = new FileInputStream(fileItem);){
                        Properties prop = new Properties();
                        prop.load(fis);
                        long timeout = Long.valueOf(prop.getProperty(timeoutKey));
                        String key = prop.getProperty(cacheKey);
                        if (System.currentTimeMillis() < timeout) continue;
                        DiskCacheUtils.remove(key);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
    }

    private static String getTimeFileUrl(String key) {
        String chidDir = DiskCacheUtils.getDiskCachePath() + String.valueOf(Math.abs(key.hashCode() % 1024)) + "/";
        File file = new File(chidDir = FileUtils.checkFileUrl(chidDir));
        if (!file.exists()) {
            file.mkdirs();
        }
        return chidDir + key + timeFileSuffix;
    }

    private static String getDataFileUrl(String key) {
        String chidDir = DiskCacheUtils.getDiskCachePath() + String.valueOf(Math.abs(key.hashCode() % 1024)) + "/";
        File file = new File(chidDir = FileUtils.checkFileUrl(chidDir));
        if (!file.exists()) {
            file.mkdirs();
        }
        return chidDir + key + dataFileSuffix;
    }

    private static boolean clearSamePrefixKeys(String prefix) {
        boolean result = true;
        String path = DiskCacheUtils.getDiskCachePath();
        File fileDir = new File(path);
        if (fileDir.isDirectory()) {
            File[] fileDirs;
            for (File fileDirItem : fileDirs = fileDir.listFiles()) {
                if (!fileDirItem.isDirectory()) continue;
                for (File fileItem : fileDirItem.listFiles()) {
                    if (!fileItem.isFile() || !fileItem.getName().endsWith(timeFileSuffix)) continue;
                    try (FileInputStream fis = new FileInputStream(fileItem);){
                        Properties prop = new Properties();
                        prop.load(fis);
                        String key = prop.getProperty(cacheKey);
                        if (!key.startsWith(prefix)) continue;
                        result = result && DiskCacheUtils.remove(key);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        return result;
    }

    private static void createTimeMetaProp(String key, int timeoutSecond) {
        String timeFileUrl = DiskCacheUtils.getTimeFileUrl(key);
        FileOutputStream oFile = null;
        try {
            oFile = new FileOutputStream(timeFileUrl);
            Properties prop = new Properties();
            long timeOut = System.currentTimeMillis() + (long)(timeoutSecond * 1000);
            prop.setProperty(cacheKey, key);
            prop.setProperty(timeoutKey, String.valueOf(timeOut));
            prop.store(oFile, "The diskCache properties file");
        }
        catch (IOException e) {
            throw new RuntimeException(Resources.getString("bos-util", "DiskCacheUtils_0", null) + timeFileUrl + " msg=" + e.getMessage(), e);
        }
        finally {
            try {
                if (oFile != null) {
                    oFile.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    private static OutputStream getOutPutStream(String fileUrl) {
        fileUrl = FileUtils.checkFileUrl(fileUrl);
        try {
            File file = new File(fileUrl);
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new RuntimeException(Resources.getString("bos-util", "DiskCacheUtils_0", null) + fileUrl + " msg=" + e.getMessage(), e);
        }
    }

    private static boolean delete(String fileUrl) {
        File file = new File(fileUrl);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    private static void writeToFile(String fileUrl, InputStream input) {
        if (input == null) {
            return;
        }
        byte[] bytes = new byte[4096];
        File file = new File(fileUrl);
        try (FileOutputStream out2 = new FileOutputStream(file);){
            int index;
            while ((index = input.read(bytes)) != -1) {
                out2.write(bytes, 0, index);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Resources.getString("bos-util", "DiskCacheUtils_1", null) + fileUrl + " msg=" + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    private static InputStream getInputStream(String fileUrl) {
        File file = new File(fileUrl = FileUtils.checkFileUrl(fileUrl));
        if (file.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                log.error(e.getMessage());
            }
            return fis;
        }
        return null;
    }

    private static String getDiskCachePath() {
        String diskCacheUrl = System.getProperty(diskCachePath);
        if ((diskCacheUrl = FileUtils.checkFileUrl(diskCacheUrl)) != null && diskCacheUrl.length() > 0) {
            File dir;
            if (!diskCacheUrl.endsWith("/")) {
                diskCacheUrl = diskCacheUrl + "/";
            }
            if (!(dir = new File(diskCacheUrl)).exists()) {
                dir.mkdirs();
            }
            return diskCacheUrl;
        }
        throw new RuntimeException(diskCachePath + Resources.getString("bos-util", "DiskCacheUtils_2", null));
    }

    private static void startClearTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    DiskCacheUtils.clearTimeoutKeys();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        };
        Timer timer = new Timer("DiskCache-cleaner");
        timer.schedule(task, 1000L, 300000L);
    }

    private static String inputStreamToString(InputStream in) {
        if (in == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byt = new byte[4096];
        try {
            int i;
            while ((i = in.read(byt)) != -1) {
                stringBuilder.append(new String(byt, 0, i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Resources.getString("bos-util", "DiskCacheUtils_3", null), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        System.setProperty(diskCachePath, "c:/diskcache");
        String abc = "it`s my first test,my name is zhangsan";
        String key = "cache_hyc_test";
        for (int i = 0; i < 1; ++i) {
            String dataKey = key + i;
            String data = abc + i;
            DiskCacheUtils.setTimeout(dataKey, 120);
            InputStream is = DiskCacheUtils.getData(dataKey);
            String abcCache = DiskCacheUtils.inputStreamToString(is);
            if (abcCache != null && data.endsWith(abcCache)) continue;
            throw new RuntimeException(Resources.getString("bos-util", "DiskCacheUtils_5", null));
        }
    }

    static {
        DiskCacheUtils.startClearTimer();
    }
}

