/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.bundle.Resources;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtils {
    private static final Logger log = LoggerFactory.getLogger(EncryptUtils.class);
    private static final String CIPHER_RSA = "RSA/ECB/PKCS1Padding";
    private static final String CIPHER_AES = "AES/ECB/PKCS5Padding";
    private static Cipher cacheDecCipher = null;
    private static final byte[] pwd = new byte[]{-82, -101, 127, 52, -8, -108, 2, 93};
    private static final String ALGORITHM = "DES";
    public static String key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Cipher getCacheDecCiphere() throws Exception {
        if (cacheDecCipher != null) return cacheDecCipher;
        Class<EncryptUtils> clazz = EncryptUtils.class;
        synchronized (EncryptUtils.class) {
            if (cacheDecCipher != null) return cacheDecCipher;
            cacheDecCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheDecCipher;
        }
    }

    public static String encrypt(String xmlStr) {
        if (xmlStr == null) {
            return null;
        }
        byte[] encrypt = null;
        try {
            encrypt = xmlStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hasn = null;
        try {
            if (encrypt != null) {
                md5Hasn = EncryptUtils.MD5Hash(encrypt, 0, encrypt.length);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] totalByte = EncryptUtils.addMD5(md5Hasn, encrypt);
        byte[] key = new byte[8];
        byte[] iv = new byte[8];
        EncryptUtils.getKeyIV(EncryptUtils.key, key, iv);
        SecretKeySpec deskey = new SecretKeySpec(key, ALGORITHM);
        IvParameterSpec ivParam = new IvParameterSpec(iv);
        byte[] temp = null;
        try {
            temp = EncryptUtils.DES_CBC_Encrypt(totalByte, deskey, ivParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Base64.encodeBase64String((byte[])temp);
    }

    public static String decrypt(String xmlStr) throws Exception {
        byte[] encBuf = Base64.decodeBase64((String)xmlStr);
        byte[] key = new byte[8];
        byte[] iv = new byte[8];
        EncryptUtils.getKeyIV(EncryptUtils.key, key, iv);
        SecretKeySpec deskey = new SecretKeySpec(key, ALGORITHM);
        IvParameterSpec ivParam = new IvParameterSpec(iv);
        byte[] temp = null;
        try {
            temp = EncryptUtils.DES_CBC_Decrypt(encBuf, deskey, ivParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = null;
        try {
            if (temp != null) {
                md5Hash = EncryptUtils.MD5Hash(temp, 16, temp.length - 16);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (md5Hash != null) {
            for (int i = 0; i < md5Hash.length; ++i) {
                if (md5Hash[i] == temp[i]) continue;
                throw new Exception(Resources.getString("bos-util", "EncryptUtils_0", null));
            }
        }
        return new String(temp, 16, temp.length - 16, "utf-8");
    }

    public static byte[] TripleDES_CBC_Encrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        Cipher encrypt = Cipher.getInstance("TripleDES/CBC/PKCS5Padding");
        encrypt.init(1, (Key)deskey, ivParam);
        byte[] cipherByte = encrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        return cipherByte;
    }

    public static byte[] TripleDES_CBC_Decrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        Cipher decrypt = Cipher.getInstance("TripleDES/CBC/PKCS5Padding");
        decrypt.init(2, (Key)deskey, ivParam);
        byte[] cipherByte = decrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        return cipherByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] DES_CBC_Encrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        byte[] cipherByte;
        Cipher encrypt;
        Cipher cipher = encrypt = EncryptUtils.getCacheDecCiphere();
        synchronized (cipher) {
            encrypt.init(1, (Key)deskey, ivParam);
            cipherByte = encrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        }
        return cipherByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] DES_CBC_Decrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        byte[] cipherByte;
        Cipher decrypt;
        Cipher cipher = decrypt = EncryptUtils.getCacheDecCiphere();
        synchronized (cipher) {
            decrypt.init(2, (Key)deskey, ivParam);
            cipherByte = decrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        }
        return cipherByte;
    }

    public static byte[] MD5Hash(byte[] buf, int offset, int length) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(buf, offset, length);
        return md.digest();
    }

    public static String byte2hex(byte[] inStr) {
        StringBuffer out2 = new StringBuffer(inStr.length * 2);
        for (int n = 0; n < inStr.length; ++n) {
            String stmp = Integer.toHexString(inStr[n] & 0xFF);
            if (stmp.length() == 1) {
                out2.append("0" + stmp);
                continue;
            }
            out2.append(stmp);
        }
        return out2.toString();
    }

    public static byte[] addMD5(byte[] md5Byte, byte[] bodyByte) {
        int length = bodyByte.length + md5Byte.length;
        byte[] resutlByte = new byte[length];
        for (int i = 0; i < length; ++i) {
            resutlByte[i] = i < md5Byte.length ? md5Byte[i] : bodyByte[i - md5Byte.length];
        }
        return resutlByte;
    }

    public static void getKeyIV(String encryptKey, byte[] key, byte[] iv) {
        int i;
        byte[] buf = null;
        buf = Base64.decodeBase64((String)encryptKey);
        for (i = 0; i < key.length; ++i) {
            key[i] = buf[i];
        }
        for (i = 0; i < iv.length; ++i) {
            iv[i] = buf[i + 8];
        }
    }

    private static byte[] encryptLarger(byte[] data, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher rsa = Cipher.getInstance(CIPHER_RSA);
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        Cipher aes = Cipher.getInstance(CIPHER_AES);
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(1, k);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = aes.doFinal(data);
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static String encryptWithEncodeBase64UTF8(String orginalContent, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Base64.encodeBase64URLSafeString((byte[])EncryptUtils.encryptLarger(orginalContent.getBytes("UTF-8"), key));
    }

    public static String encrypt(String key, String srcStr) {
        String res = null;
        SecretKeySpec deskey = new SecretKeySpec(pwd, ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, deskey);
            byte[] resByte = cipher.doFinal(srcStr.getBytes(Charsets.UTF_8));
            res = Base64.encodeBase64String((byte[])resByte);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public static String decrypt(String key, String encStr) {
        String res = null;
        SecretKeySpec deskey = new SecretKeySpec(pwd, ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, deskey);
            byte[] sourceByte = Base64.decodeBase64((String)encStr);
            res = new String(cipher.doFinal(sourceByte));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public static String encryptPSW(String strSrc) {
        String strEncode = null;
        byte[] btKey = new byte[strSrc.getBytes(Charsets.UTF_8).length + 1];
        System.arraycopy(strSrc.getBytes(Charsets.UTF_8), 0, btKey, 0, strSrc.getBytes(Charsets.UTF_8).length);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(btKey);
            byte[] btDigest = md.digest();
            strEncode = Base64.encodeBase64String((byte[])btDigest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return strEncode;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        key = "LmMGStGtOpF4xNyvYt54EQ==";
    }
}

