/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import kd.bos.util.DisCardUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static int default_connectionTimeout = 3000;
    private static int default_readTimeout = 5000;
    private static String SCHEME_HTTPS = "https";
    private static Boolean mstTls12 = Boolean.parseBoolean(System.getProperty("httpclient.tsl12.enable"));

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        return client;
    }

    public static HttpClient wrapperHttpClient(int connectionTimeout, int readTimeout) {
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws java.security.cert.CertificateException {
                }

                @Override
                public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws java.security.cert.CertificateException {
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(readTimeout).setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            return closeableHttpClient;
        }
        catch (Exception ex) {
            logger.error("\u5305\u88c5\u65e0\u8bc1\u4e66\u6821\u9a8c\u5ba2\u6237\u7aef\u5931\u8d25:" + ex.getMessage());
            return null;
        }
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpClientUtils.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        HttpClient client = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        HttpClientParams.setCookiePolicy((HttpParams)client.getParams(), (String)"compatibility");
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtils.wrapperHttpClient(connectionTimeout, readTimeout)) == null) {
            return data;
        }
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (String key : header.keySet()) {
                    post.setHeader(key, header.get(key));
                }
            }
            if (body != null && body.size() != 0) {
                Iterator<String> iterator = body.keySet().iterator();
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    String value = body.get(key).toString();
                    params.add(new BasicNameValuePair(key, value));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.warn("Http post error", (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return HttpClientUtils.postjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String data = "";
        HttpClient client = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtils.wrapperHttpClient(connectionTimeout, readTimeout)) == null) {
            return data;
        }
        try {
            if (header != null && header.size() != 0) {
                for (String key : header.keySet()) {
                    post.setHeader(key, header.get(key));
                }
            }
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.warn("Http postjson error", (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpClientUtils.postAppJson(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "application/json;";
        String data = "";
        HttpClient client = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtils.wrapperHttpClient(connectionTimeout, readTimeout)) == null) {
            return data;
        }
        try {
            if (header != null && header.size() != 0) {
                for (String key : header.keySet()) {
                    post.setHeader(key, header.get(key));
                }
            }
            String jsEntity = "{}";
            if (body != null) {
                jsEntity = JSONUtils.toString(body);
            }
            StringEntity se = new StringEntity(jsEntity, ContentType.APPLICATION_JSON);
            se.setContentType("application/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.warn("Http postjson error", (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String get(String url) throws Exception {
        return HttpClientUtils.get(url, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, int connectionTimeout, int readTimeout) throws Exception {
        BufferedReader in = null;
        String content = null;
        try {
            HttpClient client = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
            URI uri = URI.create(url);
            if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtils.wrapperHttpClient(connectionTimeout, readTimeout)) == null) {
                String string = content;
                return string;
            }
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            content = sb.toString();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error("Http get error", (Throwable)e);
                }
            }
        }
        return content;
    }

    public static String get(String url, Map<String, Object> body) {
        return HttpClientUtils.get(url, body, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> body) {
        return HttpClientUtils.get(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        return HttpClientUtils.get(url, null, body, connectionTimeout, readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> headers, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        String content = null;
        String strBody = "";
        if (body != null && body.size() != 0) {
            Iterator<String> iterator = body.keySet().iterator();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            while (iterator.hasNext()) {
                String key = iterator.next();
                String value = body.get(key).toString();
                params.add(new BasicNameValuePair(key, value));
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                strBody = EntityUtils.toString((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Http get error", (Throwable)e);
            }
            catch (ParseException e) {
                logger.error("Http get error", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Http get error", (Throwable)e);
            }
        }
        BufferedReader in = null;
        try {
            String destUrl = "";
            destUrl = StringUtils.isEmpty(strBody) ? url : url + "?" + strBody;
            HttpClient client = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
            URI uri = URI.create(url);
            if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = HttpClientUtils.wrapperHttpClient(connectionTimeout, readTimeout)) == null) {
                String string = content;
                return string;
            }
            HttpGet request = new HttpGet();
            if (headers != null && headers.size() != 0) {
                for (String key : headers.keySet()) {
                    request.setHeader(key, headers.get(key));
                }
            }
            request.setURI(new URI(destUrl));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            content = sb.toString();
        }
        catch (Exception e) {
            logger.error("Http get error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    DisCardUtil.discard();
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            logger.error("getHTMLContent error", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error("getHTMLContent error", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String putjson(String url, Map<String, String> header, String json) throws Exception {
        return HttpClientUtils.putjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        HttpClient client = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        HttpPut httpput = new HttpPut(url);
        String data = "";
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (String key : header.keySet()) {
                    httpput.setHeader(key, header.get(key));
                }
            }
            if (!StringUtils.isEmpty(json)) {
                StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
                se.setContentType("text/json;");
                httpput.setEntity((HttpEntity)se);
            }
            if ((response = client.execute((HttpUriRequest)httpput)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.error("Http putjson error", (Throwable)ex);
        }
        finally {
            httpput.releaseConnection();
        }
        return data;
    }

    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas) {
        return HttpClientUtils.postFormData(url, headers, formDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas, int connectionTimeout, int readTimeout) {
        HttpClient httpclient = HttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        try {
            HttpPost httppost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            try {
                MultipartEntity reqEntity = new MultipartEntity();
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (FormDataEntity e : formDatas) {
                        if (e.getValueInputStream() != null) {
                            reqEntity.addPart(e.getKey(), (ContentBody)new InputStreamBody(e.getValueInputStream(), e.getFileName()));
                            continue;
                        }
                        reqEntity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValueString()));
                    }
                }
                httppost.setEntity((HttpEntity)reqEntity);
                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = httpResponse.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (IOException e) {
                logger.error("Failed to post formdata.", (Throwable)e);
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public static class FormDataEntity {
        private String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

