/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import javax.servlet.http.HttpServletRequest;
import kd.bos.tenant.enums.TenantConfigTypeEnum;
import kd.bos.util.StringUtils;

public final class RevProxyUtil {
    private static final String CLIENT_DOMAIN = "clientDomain";
    public static final String VAR_TENANTALIAS = "tenantAlias";
    public static final String VAR_HTTPS = "https";
    public static final String VAR_INTERNETSITE = "InternetSite";
    public static final String DOMAINTENANTCODE = "domain.tenantCode";
    public static final String SPREAD_FLAG_OF_DOMAIN = ".";
    public static final String TENANT_CODE_TYPE_KEY = "tenant.code.type";
    public static final String DOMAINURL = "domain.contextUrl";
    public static final String OLD_IMAGEFILESERVER = "fileserver";
    public static final String ATTACHMENTFILESERVER = "attachment.fileserver";
    public static final String IMAGEFILESERVER = "image.fileserver";
    private static final String TENANTCODE_PAYLOAD = "{tenantCode}";
    private static final String TENANTCODE_PAYLOAD_REGEX = "\\{tenantCode\\}";

    public static String getTenantCode(HttpServletRequest request) {
        String tenantCode = "";
        String configue = System.getProperty(TENANT_CODE_TYPE_KEY);
        TenantConfigTypeEnum configType = TenantConfigTypeEnum.getTenantConfigTypeByString(configue);
        switch (configType) {
            case config: {
                tenantCode = System.getProperty(DOMAINTENANTCODE);
                break;
            }
            case header: {
                tenantCode = request.getHeader(VAR_TENANTALIAS);
                break;
            }
            case context: {
                tenantCode = request.getContextPath();
                break;
            }
            case subdomain: {
                String domainName = request.getServerName();
                tenantCode = RevProxyUtil.getStringFromDominByindex(domainName, 2);
                break;
            }
            case domain: {
                String domainName = request.getServerName();
                tenantCode = RevProxyUtil.getStringFromDominByindex(domainName, 1);
                break;
            }
        }
        return tenantCode;
    }

    private static String getStringFromDominByindex(String domain, int position) {
        String returnValue = "";
        if (domain != null && position >= 0) {
            String tempValue;
            String lastString = domain;
            for (int i = 0; i <= position && StringUtils.isNotEmpty(tempValue = RevProxyUtil.getLastString(lastString)); ++i) {
                if (i == position) {
                    returnValue = RevProxyUtil.getLastValue(lastString);
                }
                lastString = tempValue;
            }
        }
        return returnValue;
    }

    private static String getLastValue(String domain) {
        int lastIndex;
        String lastString = domain;
        if (domain != null && -1 != (lastIndex = domain.lastIndexOf(SPREAD_FLAG_OF_DOMAIN))) {
            lastString = domain.substring(lastIndex + 1, domain.length());
        }
        return lastString;
    }

    private static String getLastString(String domain) {
        int lastIndex;
        String lastString = domain;
        if (domain != null && -1 != (lastIndex = domain.lastIndexOf(SPREAD_FLAG_OF_DOMAIN))) {
            lastString = domain.substring(0, lastIndex);
        }
        return lastString;
    }

    private static boolean isDomainName(String domainName) {
        String newDomain;
        boolean isDomain = false;
        if (StringUtils.isNotEmpty(domainName) && domainName.lastIndexOf(SPREAD_FLAG_OF_DOMAIN) != domainName.indexOf(SPREAD_FLAG_OF_DOMAIN) && !StringUtils.isNumericString(newDomain = domainName.replace(SPREAD_FLAG_OF_DOMAIN, ""))) {
            isDomain = true;
        }
        return isDomain;
    }

    public static String getTenantId(HttpServletRequest request) {
        return RevProxyUtil.getTenantIdByCode(RevProxyUtil.getTenantCode(request));
    }

    private static String getTenantIdByCode(String tenantCode) {
        return tenantCode;
    }

    public static String getURLContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String tenantAlias = RevProxyUtil.getTenantCode(request);
        String domainUrl = request.getHeader(CLIENT_DOMAIN);
        if (StringUtils.isEmpty(domainUrl)) {
            domainUrl = System.getProperty(DOMAINURL);
        }
        if (StringUtils.isNotEmpty(domainUrl) && domainUrl.contains(TENANTCODE_PAYLOAD)) {
            domainUrl = domainUrl.replaceAll(TENANTCODE_PAYLOAD_REGEX, tenantAlias);
        }
        if (StringUtils.isNotEmpty(domainUrl)) {
            domainUrl = RevProxyUtil.addSlash(domainUrl);
        }
        return domainUrl;
    }

    public static String addSlash(String domainConfig) {
        String returnString = domainConfig;
        if (domainConfig != null) {
            returnString = !domainConfig.trim().endsWith("/") ? domainConfig.trim() + "/" : domainConfig.trim();
        }
        return returnString;
    }

    public static String removeSlash(String domainConfig) {
        String returnString = domainConfig;
        if (domainConfig != null) {
            returnString = domainConfig.trim().endsWith("/") ? domainConfig.trim().substring(0, domainConfig.trim().lastIndexOf("/")) : domainConfig.trim();
        }
        return returnString;
    }
}

