/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util.async;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SetQueue<E> {
    private ReentrantLock lock = new ReentrantLock(false);
    private Condition notEmpty = this.lock.newCondition();
    private Map<E, AtomicBoolean> m = new ConcurrentHashMap<E, AtomicBoolean>(128);
    private ConcurrentLinkedQueue<E> preRun = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIfAbsent(E sr) {
        if (sr == null) {
            return;
        }
        boolean isEmpty = this.preRun.isEmpty();
        if (!this.m.containsKey(sr)) {
            Map<E, AtomicBoolean> map = this.m;
            synchronized (map) {
                if (this.m.size() > 1000) {
                    this.m.clear();
                }
                this.preRun.add(sr);
                if (!this.m.containsKey(sr)) {
                    this.m.put(sr, new AtomicBoolean(true));
                }
            }
        } else {
            AtomicBoolean ab = this.m.get(sr);
            if (ab != null && !ab.getAndSet(true)) {
                this.preRun.add(sr);
            }
        }
        if (isEmpty) {
            try {
                this.lock.lock();
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized E poll() {
        try {
            this.lock.lock();
            E span = this.preRun.poll();
            if (span == null) {
                try {
                    this.notEmpty.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                E e = null;
                return e;
            }
            AtomicBoolean notDealTag = this.m.get(span);
            if (notDealTag != null) {
                notDealTag.set(false);
            }
            E e = span;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }
}

