/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util.jdbcproxy;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.util.jdbcproxy.PreparedStatementProxy;
import kd.bos.util.jdbcproxy.StatementProxy;

public class ConnectionProxy
implements Connection {
    protected final Connection delegate;
    private boolean wrapStatement;
    private boolean wrapPreparedStatement;
    private AtomicReference<Boolean> isAutoCommit = null;

    public ConnectionProxy(Connection conn) {
        this(conn, true, true);
    }

    public ConnectionProxy(Connection conn, boolean wrapStatement, boolean wrapPreparedStatement) {
        this.delegate = conn;
        this.wrapStatement = wrapStatement;
        this.wrapPreparedStatement = wrapPreparedStatement;
    }

    protected String wrapSQL(String sql) {
        return sql;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement a = this.delegate.createStatement();
        if (this.wrapStatement) {
            return new StatementProxy(a);
        }
        return a;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement a = this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.wrapStatement) {
            return new StatementProxy(a);
        }
        return a;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement a = this.delegate.createStatement(resultSetType, resultSetConcurrency);
        if (this.wrapStatement) {
            return new StatementProxy(a);
        }
        return a;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isAutoCommit != null) {
            return this.isAutoCommit.get();
        }
        return this.delegate.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareCall(this.wrapSQL(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareCall(this.wrapSQL(sql), resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.delegate.prepareCall(this.wrapSQL(sql));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement a = this.delegate.prepareStatement(this.wrapSQL(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.wrapPreparedStatement) {
            return new PreparedStatementProxy(a);
        }
        return a;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement a = this.delegate.prepareStatement(this.wrapSQL(sql), resultSetType, resultSetConcurrency);
        if (this.wrapPreparedStatement) {
            return new PreparedStatementProxy(a);
        }
        return a;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement a = this.delegate.prepareStatement(this.wrapSQL(sql), autoGeneratedKeys);
        if (this.wrapPreparedStatement) {
            return new PreparedStatementProxy(a);
        }
        return a;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement a = this.delegate.prepareStatement(this.wrapSQL(sql), columnIndexes);
        if (this.wrapPreparedStatement) {
            return new PreparedStatementProxy(a);
        }
        return a;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement a = this.delegate.prepareStatement(this.wrapSQL(sql), columnNames);
        if (this.wrapPreparedStatement) {
            return new PreparedStatementProxy(a);
        }
        return a;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement a = this.delegate.prepareStatement(this.wrapSQL(sql));
        if (this.wrapPreparedStatement) {
            return new PreparedStatementProxy(a);
        }
        return a;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isAutoCommit != null && this.isAutoCommit.get() == autoCommit) {
            return;
        }
        this.delegate.setAutoCommit(autoCommit);
        if (this.isAutoCommit != null) {
            this.isAutoCommit.set(autoCommit);
        } else {
            this.isAutoCommit = new AtomicReference<Boolean>(autoCommit);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.delegate.setTypeMap(map);
    }
}

