/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.tasks;

import java.io.IOException;
import java.io.InputStream;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.headers.HeaderUtil;
import kd.bos.zip.headers.HeaderWriter;
import kd.bos.zip.io.outputstream.SplitOutputStream;
import kd.bos.zip.io.outputstream.ZipOutputStream;
import kd.bos.zip.model.FileHeader;
import kd.bos.zip.model.Zip4jConfig;
import kd.bos.zip.model.ZipModel;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.CompressionMethod;
import kd.bos.zip.progress.ProgressMonitor;
import kd.bos.zip.tasks.AbstractAddFileToZipTask;
import kd.bos.zip.tasks.AbstractZipTaskParameters;
import kd.bos.zip.tasks.AsyncZipTask;
import kd.bos.zip.util.Zip4jUtil;

public class AddStreamToZipTask
extends AbstractAddFileToZipTask<AddStreamToZipTaskParameters> {
    public AddStreamToZipTask(ZipModel zipModel, char[] password, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, password, headerWriter, asyncTaskParameters);
    }

    @Override
    protected void executeTask(AddStreamToZipTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        this.verifyZipParameters(taskParameters.zipParameters);
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(taskParameters.zipParameters.getFileNameInZip())) {
            throw new ZipException("fileNameInZip has to be set in zipParameters when adding stream");
        }
        this.removeFileIfExists(this.getZipModel(), taskParameters.zip4jConfig, taskParameters.zipParameters.getFileNameInZip(), progressMonitor);
        taskParameters.zipParameters.setWriteExtendedLocalFileHeader(true);
        if (taskParameters.zipParameters.getCompressionMethod().equals((Object)CompressionMethod.STORE)) {
            taskParameters.zipParameters.setEntrySize(0L);
        }
        try (SplitOutputStream splitOutputStream = new SplitOutputStream(this.getZipModel().getZipFile(), this.getZipModel().getSplitLength());
             ZipOutputStream zipOutputStream = this.initializeOutputStream(splitOutputStream, taskParameters.zip4jConfig);){
            FileHeader fileHeader;
            byte[] readBuff = new byte[taskParameters.zip4jConfig.getBufferSize()];
            ZipParameters zipParameters = taskParameters.zipParameters;
            zipOutputStream.putNextEntry(zipParameters);
            if (!zipParameters.getFileNameInZip().endsWith("/") && !zipParameters.getFileNameInZip().endsWith("\\")) {
                int readLen;
                while ((readLen = taskParameters.inputStream.read(readBuff)) != -1) {
                    zipOutputStream.write(readBuff, 0, readLen);
                }
            }
            if ((fileHeader = zipOutputStream.closeEntry()).getCompressionMethod().equals((Object)CompressionMethod.STORE)) {
                this.updateLocalFileHeader(fileHeader, splitOutputStream);
            }
        }
    }

    @Override
    protected long calculateTotalWork(AddStreamToZipTaskParameters taskParameters) {
        return 0L;
    }

    private void removeFileIfExists(ZipModel zipModel, Zip4jConfig zip4jConfig, String fileNameInZip, ProgressMonitor progressMonitor) throws ZipException {
        FileHeader fileHeader = HeaderUtil.getFileHeader(zipModel, fileNameInZip);
        if (fileHeader != null) {
            this.removeFile(fileHeader, progressMonitor, zip4jConfig);
        }
    }

    public static class AddStreamToZipTaskParameters
    extends AbstractZipTaskParameters {
        private final InputStream inputStream;
        private final ZipParameters zipParameters;

        public AddStreamToZipTaskParameters(InputStream inputStream, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.inputStream = inputStream;
            this.zipParameters = zipParameters;
        }
    }
}

