/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.tasks;

import java.io.IOException;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.headers.HeaderWriter;
import kd.bos.zip.io.outputstream.SplitOutputStream;
import kd.bos.zip.model.EndOfCentralDirectoryRecord;
import kd.bos.zip.model.Zip4jConfig;
import kd.bos.zip.model.ZipModel;
import kd.bos.zip.progress.ProgressMonitor;
import kd.bos.zip.tasks.AbstractZipTaskParameters;
import kd.bos.zip.tasks.AsyncZipTask;

public class SetCommentTask
extends AsyncZipTask<SetCommentTaskTaskParameters> {
    private final ZipModel zipModel;

    public SetCommentTask(ZipModel zipModel, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
    }

    @Override
    protected void executeTask(SetCommentTaskTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        if (taskParameters.comment == null) {
            throw new ZipException("comment is null, cannot update Zip file with comment");
        }
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = this.zipModel.getEndOfCentralDirectoryRecord();
        endOfCentralDirectoryRecord.setComment(taskParameters.comment);
        try (SplitOutputStream outputStream = new SplitOutputStream(this.zipModel.getZipFile());){
            if (this.zipModel.isZip64Format()) {
                outputStream.seek(this.zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber());
            } else {
                outputStream.seek(endOfCentralDirectoryRecord.getOffsetOfStartOfCentralDirectory());
            }
            HeaderWriter headerWriter = new HeaderWriter();
            headerWriter.finalizeZipFileWithoutValidations(this.zipModel, outputStream, taskParameters.zip4jConfig.getCharset());
        }
    }

    @Override
    protected long calculateTotalWork(SetCommentTaskTaskParameters taskParameters) {
        return 0L;
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.SET_COMMENT;
    }

    public static class SetCommentTaskTaskParameters
    extends AbstractZipTaskParameters {
        private String comment;

        public SetCommentTaskTaskParameters(String comment, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.comment = comment;
        }
    }
}

