/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class BOSObjectType
implements Serializable {
    private static final long serialVersionUID = -65534L;
    private transient String strType;
    private transient int intType;
    private static Map<String, BOSObjectType> types = new HashMap<String, BOSObjectType>();

    private BOSObjectType(int type) {
        if (type == 0) {
            throw new IllegalArgumentException("zero BOSObjectType.");
        }
        this.intType = type;
        this.strType = null;
    }

    public BOSObjectType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null BOSObjectType.");
        }
        if ((type = type.trim()).length() == 4) {
            this.intType = 0;
            this.strType = type.intern();
        } else {
            assert (type.length() == 8);
            long parsedLong = 0L;
            try {
                parsedLong = Long.parseLong(type, 16);
                if (parsedLong > Integer.MAX_VALUE) {
                    parsedLong = Integer.MIN_VALUE + (parsedLong - Integer.MAX_VALUE - 1L);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.intType = (int)parsedLong;
            this.strType = parsedLong == 0L ? type : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOSObjectType create(String type) {
        BOSObjectType val = types.get(type);
        if (val != null) {
            return val;
        }
        Map<String, BOSObjectType> map = types;
        synchronized (map) {
            val = types.get(type);
            if (val == null) {
                val = new BOSObjectType(type);
                types.put(type, val);
            }
        }
        return val;
    }

    public String toString() {
        if (this.strType != null) {
            assert (this.intType == 0);
            return this.strType;
        }
        assert (this.intType != 0);
        return StringUtils.toHexString(this.intType, 8).toUpperCase();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof BOSObjectType) {
            if (this.strType != null) {
                return this.strType.equalsIgnoreCase(((BOSObjectType)obj).strType);
            }
            return this.intType == ((BOSObjectType)obj).intType;
        }
        return false;
    }

    public int hashCode() {
        if (this.strType != null) {
            return this.strType.hashCode();
        }
        return this.intType;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.intType);
        if (this.intType == 0) {
            out.writeUTF(this.strType);
        }
    }

    public static BOSObjectType read(DataInput in) throws IOException {
        int intType = in.readInt();
        if (intType != 0) {
            return BOSObjectType.create(new BOSObjectType(intType).toString());
        }
        String strType = in.readUTF();
        return BOSObjectType.create(strType);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.intType);
        if (this.intType == 0) {
            s.writeObject(this.strType);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.intType = s.readInt();
        if (this.intType == 0) {
            this.strType = ((String)s.readObject()).intern();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return BOSObjectType.create(this.toString());
    }

    public int toInteger() {
        return this.intType;
    }
}

