/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.bos.util.EasyTool;
import com.kingdee.bos.util.HttpRequest;
import com.kingdee.bos.util.HttpResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class HttpConnection {
    private static Logger logger = Logger.getLogger(HttpConnection.class);
    public static final String HTTPVER = "HTTP/1.1";
    public final String server;
    public final String proxyServer;
    protected boolean keep_alive = true;
    private Response response = null;
    private Socket sock = null;
    protected InputStream in = null;
    private OutputStream out = null;

    public static String getServer(String url) {
        int index;
        if (url.toLowerCase().startsWith("http://")) {
            url = url.substring(7);
        }
        if ((index = url.indexOf(47)) > 0) {
            return url.substring(0, index);
        }
        return url;
    }

    public static String getPath(String url) {
        int index;
        if (url.toLowerCase().startsWith("http://")) {
            url = url.substring(7);
        }
        if ((index = url.indexOf(47)) > 0) {
            return url.substring(index);
        }
        return "/";
    }

    public HttpConnection(String _server) throws IOException {
        this(_server, null);
    }

    public HttpConnection(String _server, String _proxyServer) throws IOException {
        this.server = _server;
        this.proxyServer = _proxyServer;
        this.connect();
    }

    private void connect() throws IOException {
        if (!this.keep_alive) {
            this.close();
        } else if (this.response != null) {
            this.response.discardData();
        }
        if (this.sock == null) {
            String host = this.server;
            if (this.proxyServer != null) {
                host = this.proxyServer;
            }
            int port = 80;
            int index = host.indexOf(58);
            if (index > 0) {
                port = Integer.parseInt(host.substring(index + 1));
                host = host.substring(0, index);
            }
            this.sock = new Socket(host, port);
            this.sock.setTcpNoDelay(true);
            this.sock.setSoLinger(false, 0);
            this.in = new BufferedInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
        }
    }

    public void close() {
        EasyTool.closeAny(this.sock);
        this.sock = null;
        this.in = null;
        this.out = null;
        this.response = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public synchronized HttpResponse sendRequest(HttpRequest request) throws IOException {
        byte[] postData;
        if (!request.existsHeader("Host")) {
            request.setHeader("Host", this.server);
        }
        String cnName = "Connection";
        if (this.proxyServer != null) {
            cnName = "Proxy-Connection";
        }
        if (!request.existsHeader(cnName)) {
            request.setHeader(cnName, "Keep-Alive");
        }
        if ((postData = request.getPostData()) != null) {
            request.setHeader("Content-Length", postData.length);
        }
        this.connect();
        try {
            String line = this.proxyServer == null ? request.getMethod() + " " + request.getPath() + " " + HTTPVER : request.getMethod() + " http://" + this.server + request.getPath() + " " + HTTPVER;
            try {
                EasyTool.writeLine(this.out, line);
            }
            catch (IOException ioe) {
                this.close();
                this.connect();
                EasyTool.writeLine(this.out, line);
            }
            request.printHeader(this.out);
            EasyTool.writeLine(this.out);
            if (postData != null && postData.length > 0) {
                this.out.write(postData);
            }
            this.out.flush();
            this.response = new Response();
            this.keep_alive = !this.response.getHeader(cnName, "Keep-Alive").equalsIgnoreCase("Close");
            return this.response;
        }
        catch (Exception e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    class ChunkedInputStream
    extends InputStream {
        InputStream in;
        byte[] data = new byte[4096];
        int size = 0;
        int pos = 0;
        boolean closed = false;

        ChunkedInputStream(InputStream _in) {
            this.in = _in;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int r = this.read(b, 0, 1);
            if (r == 0) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        private void fillData() throws IOException {
            this.size = 0;
            this.pos = 0;
            if (this.closed) {
                return;
            }
            String line = null;
            do {
                if ((line = EasyTool.readLine(this.in)) != null) continue;
                return;
            } while (line.length() <= 0);
            this.size = Integer.parseInt(line, 16);
            if (this.size > this.data.length) {
                this.data = new byte[this.size];
            }
            if (this.size > 0) {
                EasyTool.readFully(this.in, this.data, 0, this.size);
            }
            EasyTool.readLine(this.in);
            if (this.size == 0) {
                this.closed = true;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.pos == this.size) {
                this.fillData();
            }
            if (len > this.size - this.pos) {
                len = this.size - this.pos;
            }
            if (len > 0) {
                System.arraycopy(this.data, this.pos, b, off, len);
                this.pos += len;
            }
            return len;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    class FixLengthInputStream
    extends InputStream {
        int size;
        InputStream in;

        FixLengthInputStream(InputStream _in, int _size) {
            this.in = _in;
            this.size = _size;
        }

        @Override
        public int read() throws IOException {
            if (this.size == 0) {
                return -1;
            }
            --this.size;
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len > this.size) {
                len = this.size;
            }
            if (len > 0) {
                len = this.in.read(b, off, len);
                this.size -= len;
            }
            return len;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    class Response
    extends HttpResponse {
        String statusCode;
        String statusText;
        InputStream responseIn = null;

        Response() throws IOException {
            String line = null;
            do {
                if ((line = EasyTool.readLine(HttpConnection.this.in)) != null) continue;
                throw new EOFException();
            } while (line.length() <= 0);
            if (!line.equalsIgnoreCase("HTTP/1.1 200 OK")) {
                logger.info((Object)line);
            }
            int index = line.indexOf(32);
            line = line.substring(index + 1).trim();
            index = line.indexOf(32);
            this.statusCode = line.substring(0, index);
            this.statusText = line.substring(index + 1).trim();
            super.inputHeader(HttpConnection.this.in);
            if (super.getHeader("Transfer-Encoding", "").equalsIgnoreCase("chunked")) {
                this.responseIn = new ChunkedInputStream(HttpConnection.this.in);
            } else if (super.getIntHeader("Content-Length", -1) >= 0) {
                this.responseIn = new FixLengthInputStream(HttpConnection.this.in, this.getIntHeader("Content-Length"));
            } else {
                this.responseIn = HttpConnection.this.in;
                HttpConnection.this.keep_alive = false;
            }
        }

        @Override
        public String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.responseIn;
        }

        void discardData() throws IOException {
            EasyTool.copyStream(this.responseIn, null);
        }
    }
}

