/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.bos.util.EasyTool;
import com.kingdee.bos.util.IgnoreCaseProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpHeader {
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT = "Accept";
    public static final String CONNECTION = "Connection";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String CLOSE = "Close";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String HOST = "Host";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CHUNKED = "chunked";
    private final IgnoreCaseProperties values = new IgnoreCaseProperties();

    public void setHeader(String name, String value) {
        this.values.setProperty(name, value);
    }

    public void setHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public int getIntHeader(String name, int defaultValue) {
        String value = this.getHeader(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public int getIntHeader(String name) {
        return this.getIntHeader(name, 0);
    }

    public String getHeader(String name, String defaultValue) {
        return this.values.getProperty(name, defaultValue);
    }

    public String getHeader(String name) {
        return this.values.getProperty(name);
    }

    public boolean existsHeader(String name) {
        return this.values.containsProperty(name);
    }

    public String[] headerNames() {
        return (String[])EasyTool.copyArray(this.values.propertyNames(), String.class);
    }

    public void removeHeader(String name) {
        this.values.removeProperty(name);
    }

    public void removeAllHeaders() {
        this.values.clear();
    }

    public void printHeader(OutputStream out) throws IOException {
        String[] names = this.headerNames();
        for (int i = 0; i < names.length; ++i) {
            EasyTool.writeLine(out, names[i] + ": " + this.getHeader(names[i]));
        }
    }

    public void inputHeader(InputStream in) throws IOException {
        while (true) {
            String line;
            if ((line = EasyTool.readLine(in)) == null) {
                throw new EOFException();
            }
            if (line.length() == 0) break;
            int index = line.indexOf(58);
            String name = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            this.setHeader(name, value);
        }
    }
}

