/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class NoBOMInputStream
extends PushbackInputStream {
    private boolean inHead = true;
    private static final int TRY_BYTE_COUNT = 4;

    public NoBOMInputStream(InputStream in) {
        super(in, 4);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inHead) {
            this.processBOM();
            this.inHead = false;
        }
        return super.read(b, off, len);
    }

    private void processBOM() throws IOException {
        byte[] bs = new byte[4];
        int count = super.read(bs, 0, 4);
        if (count < 2) {
            super.unread(bs, 0, count);
        } else if (count == 2) {
            if (!(bs[0] == -1 && bs[1] == -2 || bs[0] == -2 && bs[1] == -1)) {
                super.unread(bs, 0, count);
            }
        } else if (count == 3) {
            if (bs[0] == -1 && bs[1] == -2 || bs[0] == -2 && bs[1] == -1) {
                super.unread(bs, 2, count - 2);
            } else if (bs[0] != -17 || bs[1] != -69 || bs[2] != -65) {
                super.unread(bs, 0, count);
            }
        } else if (bs[0] == -1 && bs[1] == -2 || bs[0] == -2 && bs[1] == -1) {
            super.unread(bs, 2, count - 2);
        } else if (bs[0] == -17 && bs[1] == -69 && bs[2] == -65) {
            super.unread(bs, 3, count - 3);
        } else if (!(bs[0] == -1 && bs[1] == -2 && bs[2] == 0 && bs[3] == 0 || bs[0] == 0 && bs[1] == 0 && bs[2] == -2 && bs[3] == -1)) {
            super.unread(bs, 0, count);
        }
    }

    public static void main(String[] args) {
    }
}

