/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class NoBOMReader
extends PushbackReader {
    private boolean inHead = true;
    private static final char BOM = '\ufeff';

    public NoBOMReader(Reader in) {
        super(in, 2);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.inHead) {
            this.processBOM();
        }
        return super.read(cbuf, off, len);
    }

    private void processBOM() throws IOException {
        char[] cs = new char[1];
        while (this.inHead) {
            int count = super.read(cs, 0, 1);
            if (count < 1) {
                super.unread(cs, 0, count);
                this.inHead = false;
                continue;
            }
            if (cs[0] == '\ufeff') continue;
            super.unread(cs, 0, count);
            this.inHead = false;
        }
    }

    public static void main(String[] args) {
    }
}

