/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util;

import com.kingdee.bos.util.NoBOMInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.util.XMLParser");

    public static Document parseXML(InputStream inputStream) throws JDOMException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The argument inputStream is null");
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException se) {
                // empty catch block
            }
            doc = builder.build((InputStream)new NoBOMInputStream(inputStream));
        }
        catch (JDOMException je) {
            logger.fatal((Object)"JDOM Parser ERROR!");
            logger.fatal((Object)("this classloader = " + XMLParser.class.getClassLoader()));
            logger.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            logger.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw je;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException se) {}
        }
        return doc;
    }

    public static Document parseXML(Reader reader) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException se) {
                // empty catch block
            }
            doc = builder.build(reader);
        }
        catch (JDOMException je) {
            logger.fatal((Object)"JDOM Parser ERROR!");
            logger.fatal((Object)("this classloader = " + XMLParser.class.getClassLoader()));
            logger.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            logger.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw je;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException se) {}
        }
        return doc;
    }

    public static SAXParserFactory createSAXParser() throws FactoryConfigurationError {
        SAXParserFactory factory = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException se) {
                // empty catch block
            }
            factory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"JAXP Parser ERROR!");
            logger.fatal((Object)("this classloader = " + XMLParser.class.getClassLoader()));
            logger.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            logger.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw e;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException se) {}
        }
        return factory;
    }

    public static void parseXML(InputStream in, DefaultHandler handler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = XMLParser.createSAXParser().newSAXParser();
        saxParser.parse((InputStream)new NoBOMInputStream(in), handler);
    }

    public static void parseXML(Reader reader, DefaultHandler handler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = XMLParser.createSAXParser().newSAXParser();
        saxParser.parse(new InputSource(reader), handler);
    }
}

