/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.backport.concurrent;

import com.kingdee.bos.util.backport.concurrent.BlockingQueue;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.DelayQueue;
import com.kingdee.bos.util.backport.concurrent.Delayed;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.bos.util.backport.concurrent.FutureTask;
import com.kingdee.bos.util.backport.concurrent.RejectedExecutionHandler;
import com.kingdee.bos.util.backport.concurrent.RunnableScheduledFuture;
import com.kingdee.bos.util.backport.concurrent.ScheduledExecutorService;
import com.kingdee.bos.util.backport.concurrent.ScheduledFuture;
import com.kingdee.bos.util.backport.concurrent.ThreadFactory;
import com.kingdee.bos.util.backport.concurrent.ThreadPoolExecutor;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import com.kingdee.bos.util.backport.concurrent.atomic.AtomicLong;
import com.kingdee.bos.util.backport.concurrent.helpers.Utils;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = Utils.nanoTime();

    final long now() {
        return Utils.nanoTime() - NANO_ORIGIN;
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return this.isRunningOrShutdown(periodic ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (this.isShutdown() && !this.canRunInCurrentRunState(task.isPeriodic()) && this.remove(task)) {
                task.cancel(false);
            }
            this.prestartCoreThread();
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture task) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(true) && this.remove(task)) {
                task.cancel(false);
            }
            this.prestartCoreThread();
        }
    }

    @Override
    void onShutdown() {
        BlockingQueue q = super.getQueue();
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            q.clear();
        } else {
            Object[] entries = q.toArray();
            for (int i = 0; i < entries.length; ++i) {
                RunnableScheduledFuture t;
                Object e = entries[i];
                if (!(e instanceof RunnableScheduledFuture) || !(!(t = (RunnableScheduledFuture)e).isPeriodic() ? !keepDelayed : !keepPeriodic) && !t.isCancelled() || !q.remove(t)) continue;
                t.cancel(false);
            }
        }
    }

    protected RunnableScheduledFuture decorateTask(Runnable runnable, RunnableScheduledFuture task) {
        return task;
    }

    protected RunnableScheduledFuture decorateTask(Callable callable, RunnableScheduledFuture task) {
        return task;
    }

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), handler);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
    }

    @Override
    public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture t = this.decorateTask(callable, (RunnableScheduledFuture)new ScheduledFutureTask(callable, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(period)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(-delay)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future submit(Runnable task, Object result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future submit(Callable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
            this.tryTerminate();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
            this.tryTerminate();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public List shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue getQueue() {
        return super.getQueue();
    }

    private static class DelayedWorkQueue
    extends AbstractCollection
    implements BlockingQueue {
        private final DelayQueue dq = new DelayQueue();

        private DelayedWorkQueue() {
        }

        @Override
        public Object poll() {
            return this.dq.poll();
        }

        @Override
        public Object peek() {
            return this.dq.peek();
        }

        @Override
        public Object take() throws InterruptedException {
            return this.dq.take();
        }

        @Override
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.dq.poll(timeout, unit);
        }

        @Override
        public boolean add(Object x) {
            return this.dq.add((RunnableScheduledFuture)x);
        }

        @Override
        public boolean offer(Object x) {
            return this.dq.offer((RunnableScheduledFuture)x);
        }

        @Override
        public void put(Object x) {
            this.dq.put((RunnableScheduledFuture)x);
        }

        @Override
        public boolean offer(Object x, long timeout, TimeUnit unit) {
            return this.dq.offer((RunnableScheduledFuture)x, timeout, unit);
        }

        @Override
        public Object remove() {
            return this.dq.remove();
        }

        @Override
        public Object element() {
            return this.dq.element();
        }

        @Override
        public void clear() {
            this.dq.clear();
        }

        @Override
        public int drainTo(Collection c) {
            return this.dq.drainTo(c);
        }

        @Override
        public int drainTo(Collection c, int maxElements) {
            return this.dq.drainTo(c, maxElements);
        }

        @Override
        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        @Override
        public boolean remove(Object x) {
            return this.dq.remove(x);
        }

        @Override
        public boolean contains(Object x) {
            return this.dq.contains(x);
        }

        @Override
        public int size() {
            return this.dq.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.dq.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.dq.toArray(array);
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator it;
                {
                    this.it = DelayedWorkQueue.this.dq.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public Object next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    private class ScheduledFutureTask
    extends FutureTask
    implements RunnableScheduledFuture {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(Runnable r, Object result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, Object result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        public int compareTo(Object other) {
            Delayed otherd = (Delayed)other;
            if (otherd == this) {
                return 0;
            }
            if (otherd instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - otherd.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : ScheduledThreadPoolExecutor.this.now() - p;
        }

        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this);
            }
        }
    }
}

