/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.encryptalgorithm;

import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.IEncryptoAlgorithm;
import com.kingdee.util.Base64Encoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class DesCrypto
implements IEncryptoAlgorithm {
    private static final byte[] pwd = new byte[]{-82, -101, 127, 52, -8, -108, 2, 93};
    private static final String ALGORITHM = "DES";
    private static Logger logger = Logger.getLogger((String)DesCrypto.class.getName());

    @Override
    public String encrypt(String key, String srcStr) throws CryptException {
        SecretKeySpec deskey = new SecretKeySpec(pwd, ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, deskey);
            byte[] resByte = cipher.doFinal(srcStr.getBytes());
            String res = Base64Encoder.byteArrayToBase64(resByte);
            return res;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("NoSuchAlgorithmException", e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("NoSuchPaddingException", e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("InvalidKeyException", e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("IllegalStateException", e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("IllegalBlockSizeException", e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("BadPaddingException", e);
        }
    }

    @Override
    public String decrypt(String key, String encStr) throws CryptException {
        SecretKeySpec deskey = new SecretKeySpec(pwd, ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, deskey);
            byte[] sourceByte = Base64Encoder.base64ToByteArray(encStr);
            String res = new String(cipher.doFinal(sourceByte));
            return res;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("NoSuchAlgorithmException", e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("NoSuchPaddingException", e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("InvalidKeyException", e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("IllegalStateException", e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("IllegalBlockSizeException", e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CryptException("BadPaddingException", e);
        }
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            if (n >= b.length - 1) continue;
            hs = hs + ",0x";
        }
        return hs.toUpperCase();
    }

    public static void main(String[] args) {
        DesCrypto des = new DesCrypto();
        String user = "";
        String pwd = "0505";
        try {
            String res = des.encrypt(user, pwd);
            logger.info((Object)("res is:" + res));
            String lres = des.decrypt(user, res);
            if (pwd.equals(lres)) {
                logger.info((Object)("lres is:" + lres));
            }
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

