/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.exception;

import com.kingdee.exception.ExceptionInfoUtil;
import com.kingdee.exception.JARExceptionInfoManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class XMLExceptionInfoManager
extends JARExceptionInfoManager {
    public static final String INFO_ROOT_DIRS = "DIRS";
    public static final String CLASS_PATH_PRFIX = "%CLASS_PATH%";

    @Override
    public void init(Properties props) throws Exception {
        String rootDirs = props.getProperty(INFO_ROOT_DIRS);
        if (rootDirs == null) {
            return;
        }
        String[] dirs = rootDirs.split(";");
        for (int i = 0; i < dirs.length; ++i) {
            this.init(new File(dirs[i]));
        }
    }

    public void init(File rootDir) throws Exception {
        if (!rootDir.isDirectory()) {
            throw new Exception("The file " + rootDir + " isn't a directory");
        }
        File[] files = rootDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.init(file);
                continue;
            }
            if (file.getName().endsWith(".properties")) {
                try {
                    ExceptionInfoUtil.processLocaleProperties(this.localeProperties, new FileInputStream(file));
                }
                catch (Exception ex) {}
                continue;
            }
            if (file.getName().endsWith(".xml")) {
                try {
                    ExceptionInfoUtil.processXML(this.exceptionInfos, new FileInputStream(file));
                }
                catch (Exception ex) {}
                continue;
            }
            if (!file.getName().equals("default.cfg")) continue;
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            String locale = props.getProperty("locale");
            if (locale == null) continue;
            this.defaultLocale = locale.toLowerCase();
        }
    }
}

