/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;

public class DynamicColInfo
extends ColInfo {
    public static DynamicColInfo copyFrom(ColInfo c) {
        DynamicColInfo dc;
        if (c instanceof DynamicColInfo) {
            dc = (DynamicColInfo)c;
        } else {
            dc = new DynamicColInfo();
            dc.nullable = c.nullable;
            dc.columnLabel = c.columnLabel;
            dc.columnName = c.columnName;
            dc.colType = c.colType;
            dc.inaccessible = c.inaccessible;
            dc.extendedProps = c.extendedProps;
            dc.colTypeName = c.colTypeName;
        }
        return dc;
    }

    public DynamicColInfo(String columnName, String columnLabel, int colType, Hashtable extProps) throws SQLException {
        super(columnName, columnLabel, colType, extProps);
    }

    public DynamicColInfo() {
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeInt(this.nullable);
        marshaller.writeObject(this.columnLabel);
        marshaller.writeObject(this.columnName);
        marshaller.writeInt(this.colType);
        marshaller.writeBoolean(this.inaccessible);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.nullable = unmarshaller.readInt();
        this.columnLabel = (String)unmarshaller.readObject();
        this.columnName = (String)unmarshaller.readObject();
        this.colType = unmarshaller.readInt();
        this.inaccessible = unmarshaller.readBoolean();
    }

    public String toString() {
        String str = "columnName: " + this.columnName;
        str = str + ", columnLabel: " + this.columnLabel;
        str = str + ", columnType: " + this.colType;
        str = str + ", nullable:" + this.nullable;
        return str;
    }
}

