/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.impl.AbstractRow;
import java.sql.SQLException;
import java.util.BitSet;
import javax.sql.RowSetMetaData;

class InsertRow
extends AbstractRow
implements Cloneable {
    private BitSet colsInserted;
    private int cols;

    InsertRow(int numCols) {
        this.vals = new Object[numCols];
        this.colsInserted = new BitSet(numCols);
        this.cols = numCols;
    }

    @Override
    protected Object getColumnObject(int i) throws SQLException {
        if (!this.colsInserted.get(i - 1)) {
            throw new SQLException("No value has been inserted");
        }
        return this.vals[i - 1];
    }

    protected void initInsertRow() {
        for (int i = 0; i < this.cols; ++i) {
            this.colsInserted.clear(i);
        }
    }

    protected boolean isCompleteRow(RowSetMetaData rsmd) throws SQLException {
        for (int i = 0; i < this.cols; ++i) {
            if (this.colsInserted.get(i) || rsmd.isNullable(i + 1) != 0) continue;
            return false;
        }
        return true;
    }

    protected void markColInserted(int i) {
        this.colsInserted.set(i);
    }

    @Override
    protected void setColumnObject(int i, Object obj) throws SQLException {
        this.vals[i - 1] = this.serializeColumnObject(obj);
        this.markColInserted(i - 1);
    }
}

