/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.BOSPropertyResourceBundle;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.SoftCache;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class BOSResourceBundle {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey();
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static final Hashtable underConstruction = new Hashtable(3, 1.0f);
    private static final Integer DEFAULT_NOT_FOUND = -1;
    private static SoftCache cacheList = new SoftCache(25, 1.0f);
    public static Locale _defaultLocale;

    private static ClassLoader getLoader() {
        ClassLoader cl = BOSResourceBundle.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static final ResourceBundle getBundle(String baseName, boolean needToReload) {
        return BOSResourceBundle.getBundle(baseName, Locale.getDefault(), needToReload);
    }

    public static final ResourceBundle getBundle(String baseName) {
        return BOSResourceBundle.getBundle(baseName, false);
    }

    private static final Locale getShortLocale(Locale longLocale, Locale defaultLocale) {
        Locale shortLocale = LocaleUtils.getShortLocale(longLocale);
        if (shortLocale == null) {
            shortLocale = defaultLocale;
        }
        return shortLocale;
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, boolean needToReload) {
        return BOSResourceBundle.getBundle(baseName, locale, BOSResourceBundle.getLoader(), needToReload);
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return BOSResourceBundle.getBundle(baseName, locale, false);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader, boolean needToReload) {
        if (loader == null) {
            throw new NullPointerException("Loader is null.");
        }
        Locale longLocale = LocaleUtils.getFirstOriginLocale(locale);
        if (longLocale == null) {
            longLocale = locale;
        }
        try {
            return BOSResourceBundle.getBundleImpl(baseName, longLocale, loader, needToReload, false);
        }
        catch (MissingResourceException e) {
            Locale sl = BOSResourceBundle.getShortLocale(longLocale, locale);
            return BOSResourceBundle.getBundleImpl(baseName, sl, loader, needToReload, true);
        }
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return BOSResourceBundle.getBundle(baseName, locale, loader, false);
    }

    private static BOSPropertyResourceBundle getBundleImpl(String baseName, Locale locale, ClassLoader loader, boolean needToReload, boolean needAutoSearch) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        Object NOTFOUND = loader != null ? loader : DEFAULT_NOT_FOUND;
        String bundleName = baseName;
        String localeSuffix = LocaleUtils.getLocaleString(locale);
        if (localeSuffix.length() > 0) {
            bundleName = bundleName + "_" + localeSuffix;
        } else if (locale.getVariant().length() > 0) {
            bundleName = bundleName + "___" + locale.getVariant();
        }
        Locale defaultLocale = Locale.getDefault();
        Object lookup = BOSResourceBundle.findBundleInCache(loader, bundleName, defaultLocale);
        if (lookup == NOTFOUND) {
            BOSResourceBundle.throwMissingResourceException(baseName, locale);
        } else if (lookup != null) {
            ((BOSPropertyResourceBundle)lookup).setNeedToReload(needToReload);
            return (BOSPropertyResourceBundle)lookup;
        }
        Object parent = NOTFOUND;
        try {
            boolean foundInMainBranch;
            Object root = BOSResourceBundle.findBundle(loader, baseName, defaultLocale, baseName, null, NOTFOUND, needToReload);
            if (root == null) {
                BOSResourceBundle.putBundleInCache(loader, baseName, defaultLocale, NOTFOUND);
                root = NOTFOUND;
            }
            Vector names = BOSResourceBundle.calculateBundleNames(baseName, locale);
            Vector<Object> bundlesFound = new Vector<Object>(3);
            boolean bl = foundInMainBranch = root != NOTFOUND && names.size() == 0;
            if (!foundInMainBranch && !needAutoSearch) {
                BOSResourceBundle.throwMissingResourceException(baseName, locale);
            }
            if (!foundInMainBranch) {
                parent = root;
                for (int i = 0; i < names.size(); ++i) {
                    bundleName = (String)names.elementAt(i);
                    lookup = BOSResourceBundle.findBundle(loader, bundleName, defaultLocale, baseName, parent, NOTFOUND, needToReload);
                    bundlesFound.addElement(lookup);
                    if (lookup == null) continue;
                    parent = lookup;
                    foundInMainBranch = true;
                }
            }
            parent = root;
            if (!foundInMainBranch) {
                Vector fallbackNames = BOSResourceBundle.calculateBundleNames(baseName, defaultLocale);
                for (int i = 0; i < fallbackNames.size() && !names.contains(bundleName = (String)fallbackNames.elementAt(i)); ++i) {
                    lookup = BOSResourceBundle.findBundle(loader, bundleName, defaultLocale, baseName, parent, NOTFOUND, needToReload);
                    if (lookup != null) {
                        parent = lookup;
                        continue;
                    }
                    BOSResourceBundle.putBundleInCache(loader, bundleName, defaultLocale, parent);
                }
            }
            parent = BOSResourceBundle.propagate(loader, names, bundlesFound, defaultLocale, parent);
        }
        catch (Exception e) {
            BOSResourceBundle.cleanUpConstructionList();
            BOSResourceBundle.throwMissingResourceException(baseName, locale);
        }
        catch (Error e) {
            BOSResourceBundle.cleanUpConstructionList();
            throw e;
        }
        if (parent == NOTFOUND) {
            BOSResourceBundle.throwMissingResourceException(baseName, locale);
        }
        if (parent != null) {
            ((BOSPropertyResourceBundle)parent).setNeedToReload(needToReload);
        }
        return (BOSPropertyResourceBundle)parent;
    }

    private static Object propagate(ClassLoader loader, Vector names, Vector bundlesFound, Locale defaultLocale, Object parent) {
        for (int i = 0; i < names.size(); ++i) {
            String bundleName = (String)names.elementAt(i);
            Object lookup = bundlesFound.elementAt(i);
            if (lookup == null) {
                BOSResourceBundle.putBundleInCache(loader, bundleName, defaultLocale, parent);
                continue;
            }
            parent = lookup;
        }
        return parent;
    }

    private static void throwMissingResourceException(String baseName, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            Collection entries = underConstruction.values();
            Thread thisThread = Thread.currentThread();
            while (entries.remove(thisThread)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader loader, String bundleName, Locale defaultLocale, String baseName, Object parent, Object NOTFOUND, boolean needToReload) {
        Object builder;
        Object result;
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            boolean beingBuilt;
            cacheKey.setKeyValues(loader, bundleName, defaultLocale);
            result = cacheList.get(cacheKey);
            if (result != null) {
                cacheKey.clear();
                return result;
            }
            builder = (Thread)underConstruction.get(cacheKey);
            boolean bl = beingBuilt = builder != null && builder != Thread.currentThread();
            if (beingBuilt) {
                while (beingBuilt) {
                    cacheKey.clear();
                    try {
                        cacheList.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    cacheKey.setKeyValues(loader, bundleName, defaultLocale);
                    beingBuilt = underConstruction.containsKey(cacheKey);
                }
                result = cacheList.get(cacheKey);
                if (result != null) {
                    cacheKey.clear();
                    return result;
                }
            }
            Object key = cacheKey.clone();
            underConstruction.put(key, Thread.currentThread());
            cacheKey.clear();
        }
        result = BOSResourceBundle.loadBundle(loader, bundleName, needToReload);
        if (result != null) {
            boolean constructing;
            builder = cacheList;
            synchronized (builder) {
                cacheKey.setKeyValues(loader, bundleName, defaultLocale);
                constructing = underConstruction.get(cacheKey) == Thread.currentThread();
                cacheKey.clear();
            }
            if (constructing) {
                BOSPropertyResourceBundle bundle = (BOSPropertyResourceBundle)result;
                if (parent != NOTFOUND && bundle.getParent() == null) {
                    bundle.setParent((BOSPropertyResourceBundle)parent);
                }
                bundle.setLocale(baseName, bundleName);
                BOSResourceBundle.putBundleInCache(loader, bundleName, defaultLocale, result);
            }
        }
        return result;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(locale.toString());
        result.add(temp.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader loader, String bundleName, Locale defaultLocale) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(loader, bundleName, defaultLocale);
            Object result = cacheList.get(cacheKey);
            cacheKey.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader loader, String bundleName, Locale defaultLocale, Object value) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(loader, bundleName, defaultLocale);
            cacheList.put(cacheKey.clone(), value);
            underConstruction.remove(cacheKey);
            cacheKey.clear();
            cacheList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BOSPropertyResourceBundle loadBundle(final ClassLoader loader, String bundleName, boolean needToReload) {
        final String resName = bundleName.replace('.', '/') + ".properties";
        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(resName);
                }
                return ClassLoader.getSystemResourceAsStream(resName);
            }
        });
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            try {
                BOSPropertyResourceBundle bOSPropertyResourceBundle = new BOSPropertyResourceBundle(stream, resName, loader, needToReload);
                return bOSPropertyResourceBundle;
            }
            catch (Exception e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    static boolean needToReload() {
        return true;
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private Locale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            try {
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                return otherEntry.loaderRef != null && this.loaderRef.get() == otherEntry.loaderRef.get();
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader loader, String searchName, Locale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
            if (loader == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference<ClassLoader>(loader);
                this.hashCodeCache ^= loader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "", null);
        }
    }
}

