/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.io.Serializable;
import java.util.BitSet;

public class CharBitSet
extends BitSet
implements Serializable {
    public static final int MASK_LENGTH = 255;
    private final int maskLength;

    public CharBitSet() {
        this(255);
    }

    public CharBitSet(int maskLength) {
        super(maskLength);
        this.maskLength = maskLength;
    }

    public CharBitSet(String mask) {
        super(mask == null || mask.length() == 0 ? 255 : mask.length());
        this.maskLength = mask == null || mask.length() == 0 ? 255 : mask.length();
        this.init(mask);
    }

    public CharBitSet(String mask, int maskLength) {
        super(maskLength);
        this.maskLength = maskLength;
        this.init(mask);
    }

    private void init(String mask) {
        if (mask == null || mask.length() == 0) {
            return;
        }
        int len = (mask = mask.trim()).length();
        if (len > this.size()) {
            throw new IllegalArgumentException("Mask out of range.");
        }
        char[] bits = mask.toCharArray();
        for (int i = 0; i < len; ++i) {
            assert (bits[len - i - 1] == '1' || bits[len - i - 1] == '0');
            if (bits[len - i - 1] != '1') continue;
            this.set(i);
        }
    }

    public int getMaskLength() {
        return this.maskLength;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = this.maskLength; i > 0; --i) {
            if (this.get(i - 1)) {
                buffer.append("1");
                continue;
            }
            buffer.append("0");
        }
        return buffer.toString();
    }

    public void not() {
        BitSet bt = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            bt.set(i);
        }
        this.xor(bt);
    }

    public boolean isZero() {
        return this.equals(new CharBitSet(this.size()));
    }

    public static String and(String mask1, String mask2) {
        CharBitSet cb1 = new CharBitSet(mask1);
        CharBitSet cb2 = new CharBitSet(mask2);
        cb1.and(cb2);
        return cb1.toString();
    }

    public static String or(String mask1, String mask2) {
        CharBitSet cb1 = new CharBitSet(mask1);
        CharBitSet cb2 = new CharBitSet(mask2);
        cb1.or(cb2);
        return cb1.toString();
    }

    public static String xor(String mask1, String mask2) {
        CharBitSet cb1 = new CharBitSet(mask1);
        CharBitSet cb2 = new CharBitSet(mask2);
        cb1.xor(cb2);
        return cb1.toString();
    }

    public static String not(String mask) {
        CharBitSet cb = new CharBitSet(mask);
        cb.not();
        return cb.toString();
    }
}

