/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.FIFOMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class FIFOSet<E>
extends AbstractSet<E>
implements Set<E> {
    private transient FIFOMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public FIFOSet() {
        this.map = new FIFOMap();
    }

    public FIFOSet(Collection<? extends E> c) {
        this.map = new FIFOMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public FIFOSet(int initialCapacity, float loadFactor) {
        this.map = new FIFOMap(initialCapacity, loadFactor);
    }

    public FIFOSet(int initialCapacity) {
        this.map = new FIFOMap(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    public void setMaxSize(int maxSize) {
        this.map.setMaxSize(maxSize);
    }
}

