/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

class InnerObjectInputStream
extends ObjectInputStream {
    private ClassLoader innerLoader = null;

    public InnerObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    public InnerObjectInputStream() throws IOException, SecurityException {
    }

    public InnerObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
        this(in);
        this.innerLoader = loader;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (Exception e) {
            if (this.innerLoader != null) {
                return this.innerLoader.loadClass(desc.getName());
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            throw new ClassNotFoundException("Can not found class " + desc.getName());
        }
    }
}

