/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.BOSResourceBundle;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.ResourceProviderManager;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class NumericException
extends BaseException
implements Serializable {
    protected NumericExceptionSubItem info;
    protected Object[] params;

    public abstract String getMainCode();

    protected NumericException(NumericExceptionSubItem info, Throwable cause, Object[] params) {
        super(cause);
        this.info = info;
        this.params = params;
    }

    protected NumericException(NumericExceptionSubItem info, Object[] params) {
        this.info = info;
        this.params = params;
    }

    public String getCode() {
        return this.getMainCode() + "-" + this.getSubCode();
    }

    public String getSubCode() {
        return this.info.getCode();
    }

    @Override
    public String getMessage() {
        return this.getMessage(null);
    }

    public String getMessage(Locale locale) {
        String s;
        String name;
        Locale thisLocale;
        String msg = "";
        if (locale == null) {
            try {
                Class<?> clazz = Class.forName("com.kingdee.bos.ContextUtils");
                Method m = clazz.getMethod("getOriginalLocaleFromEnv", null);
                thisLocale = (Locale)m.invoke(null, null);
            }
            catch (Throwable t) {
                thisLocale = LocaleUtils.getDefaultOriginLocale();
            }
        } else {
            thisLocale = locale;
        }
        if ((name = this.info.getName()) == null) {
            return msg;
        }
        if (ResourceProviderManager.isMultiLanguages() && !StringUtils.isEmpty(s = ResourceProviderManager.getExceptionString(this.getClass().getName(), thisLocale, name))) {
            s = s.replaceAll("'", "''");
            return MessageFormat.format(s, this.params);
        }
        try {
            ResourceBundle bundle = BOSResourceBundle.getBundle(this.getClass().getName(), thisLocale);
            msg = bundle.getString(name);
        }
        catch (MissingResourceException mre) {
            msg = name;
        }
        msg = msg.replaceAll("'", "''");
        return MessageFormat.format(msg, this.params);
    }

    public void afterShowException(Map context) {
    }
}

