/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.db;

import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.KeyDef;
import com.kingdee.util.db.TableDesc;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommandBuilder {
    private final Connection cn;
    private final TableDesc tableDesc;
    protected final Map values;
    private static Logger logger = Logger.getLogger(CommandBuilder.class);

    public CommandBuilder(Connection cn, String tableName) {
        this.cn = cn;
        this.tableDesc = new TableDesc(tableName);
        this.values = new HashMap();
    }

    public CommandBuilder(Connection cn, TableDesc tableDesc, Map values) {
        this.cn = cn;
        this.tableDesc = tableDesc;
        this.values = values;
    }

    public CommandBuilder addField(String name, Object value, int sqltype) {
        if (value == null || value.toString().length() == 0) {
            this.values.put(name, "");
        } else {
            this.values.put(name, value);
        }
        this.tableDesc.addFieldDesc(name, sqltype);
        return this;
    }

    public void delete(String pkField, String id) throws SQLException {
        int affectedRows = this.delete(pkField, id, 12);
        if (affectedRows > 1) {
            throw new SQLException("There were " + affectedRows + " rows deleted in the DBMS with this record's identity value.");
        }
        if (affectedRows != 1) {
            throw new SQLException("There were " + affectedRows + " rows deleted in the DBMS.");
        }
    }

    public int delete(String keyfield, Object keyvalue, int sqltype) throws SQLException {
        KeyDef keydef = new KeyDef().addAttrib(keyfield);
        this.addField(keyfield, keyvalue, sqltype);
        return this.delete(keydef);
    }

    public int delete(KeyDef keydef) throws SQLException {
        int affectedRows = 0;
        String s = this.getDeleteString(keydef);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "delete", s);
        }
        Statement preparedStmt = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" *** sql is : \n" + s));
            }
            preparedStmt = this.cn.prepareStatement(s);
            int size = keydef.size();
            for (int i = 1; i <= size; ++i) {
                String key = keydef.getAttrib(i);
                Object value = this.values.get(key);
                if (value == null) {
                    throw new SQLException("Cannot delete record from table: '" + this.tableDesc.tableName + "' with a NULL key value");
                }
                this.tableDesc.bindToParam((PreparedStatement)preparedStmt, i, key, value);
            }
            affectedRows = preparedStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (preparedStmt != null) {
                try {
                    preparedStmt.close();
                }
                catch (SQLException _) {}
            }
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
        }
        return affectedRows;
    }

    public void addnew() throws SQLException {
        String s = this.getInsertString();
        Statement preparedStmt = null;
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "addnew", s);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" *** sql is : \n" + s));
            }
            preparedStmt = this.cn.prepareStatement(s);
            int i = 1;
            for (Map.Entry entry : this.values.entrySet()) {
                String field = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                this.tableDesc.bindToParam((PreparedStatement)preparedStmt, i++, field, value);
            }
            preparedStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (preparedStmt != null) {
                try {
                    preparedStmt.close();
                }
                catch (SQLException _) {}
            }
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public void update(String pkField, String id) throws SQLException {
        assert (id != null);
        assert (id.equals(TypeConversionUtils.objToString(this.values.get(pkField))));
        int affectedRows = this.update(pkField, id, 12);
        if (affectedRows > 1) {
            throw new SQLException("There were " + affectedRows + " rows updated in the DBMS!");
        }
    }

    public int update(String keyfield, Object keyvalue, int sqltype) throws SQLException {
        if (!this.tableDesc.types.containsKey(keyfield)) {
            this.tableDesc.types.put(keyfield, sqltype);
        }
        KeyDef keydef = new KeyDef().addAttrib(keyfield);
        HashMap<String, Object> keyvalues = new HashMap<String, Object>();
        keyvalues.put(keyfield, keyvalue);
        return this.update(keydef, keyvalues);
    }

    public int update(KeyDef keydef, Map keyvalues) throws SQLException {
        assert (!this.values.isEmpty());
        int affectedRows = 0;
        String s = this.getUpdateString(keydef);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "update", s);
        }
        Statement preparedStmt = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" *** sql is : \n" + s));
            }
            preparedStmt = this.cn.prepareStatement(s);
            int l = 1;
            for (Map.Entry entry : this.values.entrySet()) {
                String field = (String)entry.getKey();
                Object value = entry.getValue();
                this.tableDesc.bindToParam((PreparedStatement)preparedStmt, l++, field, value);
            }
            int size = keydef.size();
            for (int i = 1; i <= size; ++i) {
                String keyfield = keydef.getAttrib(i);
                Object keyvalue = keyvalues.get(keyfield);
                if (keyvalue == null) {
                    throw new SQLException("Cannot update record in table '" + this.tableDesc.tableName + "' with a NULL key value for '" + keyfield + "'");
                }
                this.tableDesc.bindToParam((PreparedStatement)preparedStmt, l++, keyfield, keyvalue);
            }
            affectedRows = preparedStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (preparedStmt != null) {
                try {
                    preparedStmt.close();
                }
                catch (SQLException _) {}
            }
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
        }
        return affectedRows;
    }

    private String getInsertString() {
        StringBuffer strfields = new StringBuffer();
        StringBuffer strvalues = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : this.values.entrySet()) {
            String field = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (!first) {
                strfields.append(", ");
                strvalues.append(", ");
            }
            strfields.append(field);
            strvalues.append("?");
            first = false;
        }
        return new StringBuffer().append("insert into ").append(this.tableDesc.tableName).append(" (").append(strfields).append(") values (").append(strvalues).append(")").toString();
    }

    private String getUpdateString(KeyDef keydef) throws SQLException {
        if (keydef == null || keydef.size() == 0) {
            throw new SQLException("Cannot update table " + this.tableDesc.tableName + " with an empty KeyDef specified!");
        }
        StringBuffer strnamevalues = new StringBuffer();
        StringBuffer strwhere = new StringBuffer();
        boolean first = true;
        Iterator iter = this.values.entrySet().iterator();
        while (iter.hasNext()) {
            String field = (String)iter.next().getKey();
            if (!first) {
                strnamevalues.append(", ");
            }
            strnamevalues.append(field).append(" = ?");
            first = false;
        }
        first = true;
        int size = keydef.size();
        for (int i = 1; i <= size; ++i) {
            if (!first) {
                strwhere.append(" AND ");
            }
            strwhere.append(keydef.getAttrib(i)).append(" = ? ");
            first = false;
        }
        return new StringBuffer().append("update ").append(this.tableDesc.tableName).append(" set ").append(strnamevalues).append(" where ").append(strwhere).toString();
    }

    private String getDeleteString(KeyDef keydef) throws SQLException {
        if (keydef.size() == 0) {
            throw new SQLException("Cannot update table " + this.tableDesc.tableName + " with an empty KeyDef specified");
        }
        StringBuffer strwhere = new StringBuffer();
        boolean first = true;
        int size = keydef.size();
        for (int i = 1; i <= size; ++i) {
            if (!first) {
                strwhere.append(" AND ");
            }
            strwhere.append(keydef.getAttrib(i)).append(" = ? ");
            first = false;
        }
        return new StringBuffer().append("delete from ").append(this.tableDesc.tableName).append(" where ").append(strwhere).toString();
    }
}

