/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.profile;

import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ProfileConfig {
    private static final String CONFIG_FILE_NAME = "profilelog.properties";
    public final String filename;
    public final int maxFileSize;
    public boolean console;
    public final boolean logEnable;
    public final boolean logRPCInvoke;
    public final boolean logRemoteObject;
    public final boolean logLocalObject;
    public final boolean logTxInvoker;
    public final boolean logService;
    public final boolean logORMapping;
    public final boolean logQuery;
    public final boolean logWfEngine;
    private static ProfileConfig instance = null;

    public static ProfileConfig getInstance() {
        if (instance == null) {
            instance = Init.instance;
        }
        return instance;
    }

    private ProfileConfig() {
        Properties props = this.loadConfig();
        this.filename = this.getString(props, "fileName", "profile.csv");
        this.maxFileSize = this.getInt(props, "maxFileSize", 1024);
        this.console = this.getBoolean(props, "console", false);
        this.logEnable = this.getBoolean(props, "logEnable", false);
        this.logRPCInvoke = this.logEnable && this.getBoolean(props, "logRPCInvoke", true);
        this.logRemoteObject = this.logEnable && this.getBoolean(props, "logRemoteObject", true);
        this.logLocalObject = this.logEnable && this.getBoolean(props, "logLocalObject", true);
        this.logTxInvoker = this.logEnable && this.getBoolean(props, "logTxInvoker", false);
        this.logService = this.logEnable && this.getBoolean(props, "logService", false);
        this.logORMapping = this.logEnable && this.getBoolean(props, "logORMapping", true);
        this.logQuery = this.logEnable && this.getBoolean(props, "logQuery", true);
        this.logWfEngine = this.logEnable && this.getBoolean(props, "logWfEngine", true);
    }

    private Properties loadConfig() {
        Properties props = new Properties();
        try {
            File configFile = new File(CONFIG_FILE_NAME);
            if (configFile.exists()) {
                props.load(new FileInputStream(configFile));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private boolean getBoolean(Properties props, String key, boolean defaultValue) {
        String b = this.getString(props, key, Boolean.toString(defaultValue));
        try {
            return TypeConversionUtils.objToBoolean(b);
        }
        catch (IllegalConversionException _ex) {
            return defaultValue;
        }
    }

    private int getInt(Properties props, String key, int defaultValue) {
        String i = this.getString(props, key, Integer.toString(defaultValue));
        try {
            return TypeConversionUtils.objToInt(i);
        }
        catch (IllegalConversionException _ex) {
            return defaultValue;
        }
    }

    private String getString(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    private static class Init {
        private static final ProfileConfig instance = new ProfileConfig();

        private Init() {
        }
    }
}

