/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.profile;

import com.kingdee.bos.util.UniqueID;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ProfileLogger;
import java.util.Date;
import java.util.Stack;

public class ThreadProfileContext {
    private static final long processId = System.currentTimeMillis();
    private static final UniqueID txIdGenerator = new UniqueID(0L);
    private static final UniqueID logSeqGenerator = new UniqueID(0L);
    private final int threadId;
    private long transactionId;
    private Stack stack;
    private static ThreadLocal threadCtx = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadProfileContext(Thread.currentThread().hashCode());
        }
    };

    public static ThreadProfileContext getInstance() {
        return (ThreadProfileContext)threadCtx.get();
    }

    private ThreadProfileContext(int threadId) {
        this.threadId = threadId;
        this.stack = new Stack();
    }

    public int getThreadId() {
        return this.threadId;
    }

    public long getTransactionID() {
        return this.transactionId;
    }

    public int getStackLevel() {
        return this.stack.size();
    }

    public void enter(String clazz, String method, String description) {
        if (!ProfileConfig.getInstance().logEnable) {
            return;
        }
        if (this.stack.size() == 0) {
            this.transactionId = txIdGenerator.next();
        }
        ThreadProfileEntry entry = new ThreadProfileEntry(clazz, method, description);
        this.stack.push(entry);
    }

    public void enter() {
        this.enter(null, null, null);
    }

    public void setTopEntry(String clazz, String method, String description) {
        ThreadProfileEntry e = (ThreadProfileEntry)this.stack.get(this.stack.size());
        e.setEntry(clazz, method, description);
    }

    public void exit() {
        if (!ProfileConfig.getInstance().logEnable) {
            return;
        }
        long endTime = System.currentTimeMillis();
        ThreadProfileEntry entry = (ThreadProfileEntry)this.stack.pop();
        String[] profs = new String[]{Long.toString(logSeqGenerator.next()), Long.toHexString(processId), Long.toString(this.transactionId), Integer.toHexString(this.threadId), entry.clazz, entry.method, entry.description, Integer.toString(this.getStackLevel()), DateTimeUtils.format(new Date(entry.beginTime), "yyyy/MM/dd HH:mm:ss:SSS"), Long.toString(endTime - entry.beginTime)};
        ProfileLogger.write(profs);
    }

    public static Object[] toValues(String[] values) {
        Object[] objs = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            objs[i] = i == 0 || i == 7 || i == 9 ? Integer.valueOf(Integer.parseInt(values[i])) : values[i];
        }
        return objs;
    }

    public static void main(String[] args) {
        ThreadProfileContext prof = ThreadProfileContext.getInstance();
        prof.enter(ThreadProfileContext.class.getName(), "main", "");
        prof.enter(ThreadProfileContext.class.getName(), "main", "");
        prof.exit();
        prof.exit();
        System.out.println();
    }

    private class ThreadProfileEntry {
        String clazz;
        String method;
        String description;
        final long beginTime = System.currentTimeMillis();

        ThreadProfileEntry() {
        }

        ThreadProfileEntry(String clazz, String method, String description) {
            this();
            this.setEntry(clazz, method, description);
        }

        void setEntry(String clazz, String method, String description) {
            this.clazz = clazz;
            this.method = method;
            this.description = !StringUtils.isEmpty(description) ? description.replace(',', '/') : null;
        }
    }
}

