/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.cache;

import com.kingdee.eas.common.cache.CacheConfigNode;
import com.kingdee.util.ConfigurationException;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class CacheXMLConfiguration {
    private Document doc;
    private Element root;
    private File file;
    private URL url;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.util.CacheConfigXMLUtils");
    private static Map storeLevelMap = new HashMap();

    private CacheXMLConfiguration(File file) {
        this.file = file;
    }

    private CacheXMLConfiguration(URL url) {
        this.url = url;
    }

    public static CacheXMLConfiguration getInstance(URL url) throws ConfigurationException {
        CacheXMLConfiguration myself = new CacheXMLConfiguration(url);
        myself.load();
        return myself;
    }

    public static CacheXMLConfiguration newInstance(URL url) throws ConfigurationException {
        CacheXMLConfiguration myself = new CacheXMLConfiguration(url);
        myself.createNew();
        return myself;
    }

    public static CacheXMLConfiguration getInstance(File file) throws ConfigurationException {
        CacheXMLConfiguration myself = new CacheXMLConfiguration(file);
        myself.load();
        return myself;
    }

    public static CacheXMLConfiguration newInstance(File file) throws ConfigurationException {
        CacheXMLConfiguration myself = new CacheXMLConfiguration(file);
        myself.createNew();
        return myself;
    }

    public void addConfigNode(CacheConfigNode node) {
        this.root.addContent(node.el);
    }

    public List getCacheConfigNodeList(String name) {
        List _els = CacheXMLConfiguration.getCacheConfigNodeElementList(this.root, name);
        if (_els != null) {
            ArrayList<CacheConfigNode> items = new ArrayList<CacheConfigNode>();
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                CacheConfigNode item = new CacheConfigNode(_el);
                items.add(item);
            }
            return items;
        }
        return null;
    }

    public List getEntityConfigList() {
        List _els = this.root.getChildren("entity");
        ArrayList<CacheConfigNode> children = new ArrayList<CacheConfigNode>();
        for (int i = 0; _els != null && i < _els.size(); ++i) {
            Element _el = (Element)_els.get(i);
            children.add(new CacheConfigNode(_el));
        }
        return children;
    }

    public List getFacadeConfigList() {
        List _els = this.root.getChildren("facade");
        ArrayList<CacheConfigNode> children = new ArrayList<CacheConfigNode>();
        for (int i = 0; _els != null && i < _els.size(); ++i) {
            Element _el = (Element)_els.get(i);
            children.add(new CacheConfigNode(_el));
        }
        return children;
    }

    public CacheConfigNode getCacheConfigNodeByPath(String path) {
        Element _el = CacheXMLConfiguration.getCacheConfigNodeElementByPath(this.root, path);
        if (_el != null) {
            return new CacheConfigNode(_el);
        }
        return null;
    }

    public void updateCacheConfigVersion() {
        String version = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        this.root.setAttribute("version", version);
    }

    public String getCacheConfigVersion() {
        return this.root.getAttributeValue("version");
    }

    public void updateCacheConfigSize(int cacheSize) {
        this.root.setAttribute("cacheSize", cacheSize + "");
    }

    public int getCacheConfigSize() {
        return Integer.parseInt(this.root.getAttributeValue("cacheSize"));
    }

    public boolean isSystemCacheEnabled() {
        return "true".equalsIgnoreCase(this.root.getAttributeValue("isSystemCacheEnabled"));
    }

    public void setSystemCacheEnabled(boolean isEnabled) {
        this.root.setAttribute("isSystemCacheEnabled", isEnabled + "");
    }

    public CacheConfigNode getEntityMethodConfig(String bosType, String methodName) {
        String path = "/config/entity[@bostype='" + bosType + "']/method[@name='" + methodName + "']";
        return this.getCacheConfigNodeByPath(path);
    }

    public CacheConfigNode getFacadeMethodConfig(String bosType, String methodName) {
        String path = "/config/facade[@bostype='" + bosType + "']/method[@name='" + methodName + "']";
        return this.getCacheConfigNodeByPath(path);
    }

    public CacheConfigNode getEntityConfigNode(String entityName, String methodName) {
        String path = "//entity[@name='" + entityName + "']//method[@name='" + methodName + "']";
        return this.getCacheConfigNodeByPath(path);
    }

    public CacheConfigNode getFacadeConfigNode(String facadeName, String methodName) {
        String path = "//facade[@name='" + facadeName + "']//method[@name='" + methodName + "']";
        return this.getCacheConfigNodeByPath(path);
    }

    public CacheConfigNode getConfigNodeByBostype(String nodeType, String bosType) {
        String path = "/config/" + nodeType + "[@bostype='" + bosType + "']";
        return this.getCacheConfigNodeByPath(path);
    }

    public List getCacheConfigNodeListByPath(String name) {
        List _els = CacheXMLConfiguration.getCacheConfigNodeElementListByPath(this.root, name);
        if (_els != null) {
            ArrayList<CacheConfigNode> items = new ArrayList<CacheConfigNode>();
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                CacheConfigNode item = new CacheConfigNode(_el);
                items.add(item);
            }
            return items;
        }
        return null;
    }

    public void removeCacheConfigNode(CacheConfigNode node) {
        Element _el = node.el;
        if (_el != null) {
            this.root.removeContent(_el);
        }
    }

    public void removeChildren(String name) {
        List _els = CacheXMLConfiguration.getCacheConfigNodeElementList(this.root, name);
        if (_els != null) {
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                if (_el == null) continue;
                this.root.removeContent(_el);
            }
        }
    }

    public void removeAll() {
        this.root.removeChildren("entity");
        this.root.removeChildren("facade");
    }

    public void store() throws ConfigurationException {
        this.store(true);
    }

    public void store(boolean createNewFile) throws ConfigurationException {
        XMLOutputter outputter = new XMLOutputter("   ", true);
        OutputStream os = null;
        try {
            if (this.file != null) {
                if (createNewFile && !this.file.exists()) {
                    this.file.createNewFile();
                }
                os = new FileOutputStream(this.file);
            } else if (this.url != null) {
                os = this.url.openConnection().getOutputStream();
            }
            outputter.setTrimAllWhite(true);
            outputter.output(this.doc, os);
            os.close();
        }
        catch (Exception e) {
            throw new ConfigurationException("store config information failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    logger.error((Object)"cannot close OutputStream", (Throwable)e1);
                }
            }
        }
    }

    public void reload() throws ConfigurationException {
        try {
            this.root.detach();
            this.root = null;
            this.doc = null;
            if (this.file == null && this.url == null) {
                throw new ConfigurationException("config file not exists.");
            }
            if (this.file != null && this.file.exists()) {
                logger.debug((Object)("reload config file: " + this.file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.file);
            } else if (this.url != null) {
                logger.debug((Object)("reload config from url: " + this.url.getFile()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.url);
            } else {
                throw new ConfigurationException("config file not exists");
            }
            this.root = this.doc.getRootElement();
            if (!this.root.getName().equals("config")) {
                throw new ConfigurationException("not a config file,root tag must be 'config'");
            }
        }
        catch (IOException ie) {
            logger.error((Object)ie);
            throw new ConfigurationException("read config error ", (Throwable)ie);
        }
        catch (JDOMException de) {
            throw new ConfigurationException("parse file error ", (Throwable)de);
        }
    }

    private void load() throws ConfigurationException {
        try {
            if (this.file == null && this.url == null) {
                throw new ConfigurationException("config file not exists.");
            }
            if (this.file != null && this.file.exists()) {
                logger.debug((Object)("read config file: " + this.file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.file);
            } else if (this.url != null) {
                logger.debug((Object)("read config from url: " + this.url.getFile()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.url);
            } else {
                throw new ConfigurationException("config file not exists");
            }
            this.root = this.doc.getRootElement();
            if (!this.root.getName().equals("config")) {
                throw new ConfigurationException("not a config file,root tag must be 'config'");
            }
        }
        catch (IOException ie) {
            logger.error((Object)ie);
            throw new ConfigurationException("read config error ", (Throwable)ie);
        }
        catch (JDOMException de) {
            throw new ConfigurationException("parse file error ", (Throwable)de);
        }
    }

    private void createNew() throws ConfigurationException {
        if (this.file == null && this.url == null) {
            throw new ConfigurationException("config file not exists.");
        }
        if (this.file != null && this.file.exists()) {
            logger.debug((Object)("read config file: " + this.file.getAbsolutePath()));
        } else if (this.url != null) {
            logger.debug((Object)("read config from url: " + this.url.getFile()));
        } else {
            throw new ConfigurationException("config file not exists");
        }
        this.root = new Element("config");
        String version = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        this.root.setAttribute("version", version);
        this.root.setAttribute("cacheSize", "0");
        this.root.setAttribute("isSystemCacheEnabled", "true");
        this.doc = new Document();
        this.doc.setRootElement(this.root);
    }

    public void dump(PrintStream ps) {
        CacheXMLConfiguration.dumpItem(ps, "", this.root);
    }

    static void dumpItem(PrintStream ps, String space, Element _el) {
        if (!_el.getName().equals("config")) {
            ps.println(space + "[configitem]:" + _el.getAttributeValue("name"));
        }
        List _listAttr = _el.getChildren("attribute");
        for (int i = 0; i < _listAttr.size(); ++i) {
            Element __el = (Element)_listAttr.get(i);
            ps.println(space + "  attribute " + __el.getAttributeValue("key") + " = " + __el.getAttributeValue("value"));
        }
        List _listConfigItem = _el.getChildren("configitem");
        for (int i = 0; i < _listConfigItem.size(); ++i) {
            Element __el = (Element)_listConfigItem.get(i);
            CacheXMLConfiguration.dumpItem(ps, space + "    ", __el);
        }
    }

    static Element getCacheConfigNodeElementByPath(Element el, String path) {
        Element _el = null;
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)path);
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    static List getCacheConfigNodeElementList(Element el, String name) {
        List _els = null;
        try {
            _els = XPath.selectNodes((Object)el, (String)("configitem[lower-case(attribute::name)='" + name.toLowerCase() + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _els;
    }

    static List getCacheConfigNodeElementListByPath(Element el, String path) {
        List _els = null;
        try {
            _els = XPath.selectNodes((Object)el, (String)path);
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _els;
    }

    public static void main(String[] args) {
        CacheConfigNode node2;
        File xmlFile = new File("C:/CacheConfig.xml");
        if (!xmlFile.exists()) {
            try {
                xmlFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CacheXMLConfiguration cacheConfig = CacheXMLConfiguration.getInstance(xmlFile);
        List entities = cacheConfig.getEntityConfigList();
        List facades = cacheConfig.getFacadeConfigList();
        boolean count = false;
        for (CacheConfigNode node2 : entities) {
            for (CacheConfigNode mnode : node2.getMethods()) {
            }
        }
        node2 = cacheConfig.getCacheConfigNodeByPath("//entity[@name='CostObject']//method[@name='checkMaterialUsed']");
    }

    public boolean isServerCacheEnabled() {
        return "true".equalsIgnoreCase(this.root.getAttributeValue("serverEnable"));
    }

    public String[] getMemcacheServerList() {
        String serverStr = this.root.getAttributeValue("memServer");
        if (serverStr == null || serverStr.trim().length() == 0) {
            return null;
        }
        String[] serverArray = serverStr.split(",");
        if (serverArray.length == 0) {
            return null;
        }
        return serverArray;
    }

    public int getMemcacheHashAlg() {
        String HashAlg = this.root.getAttributeValue("HashAlg");
        if (HashAlg == null) {
            return 0;
        }
        return Integer.parseInt(HashAlg);
    }

    public boolean isIgnoreException() {
        String ignoreException = this.root.getAttributeValue("ignoreException");
        if (ignoreException == null) {
            return true;
        }
        return Boolean.valueOf(ignoreException);
    }

    public Map getStoreLevelMap() {
        storeLevelMap.clear();
        Element el = this.root.getChild("custom");
        if (el == null) {
            return null;
        }
        List modules = el.getChildren("module");
        if (modules == null) {
            return null;
        }
        for (int i = 0; i < modules.size(); ++i) {
            Element module = (Element)modules.get(i);
            String moduleName = module.getAttributeValue("name");
            List props = module.getChildren();
            for (int j = 0; j < props.size(); ++j) {
                Element prop = (Element)props.get(j);
                String propName = prop.getAttributeValue("name");
                String propStoreLevel = prop.getAttributeValue("storelevel");
                String propAutoDegrade = prop.getAttributeValue("autoDegrade");
                String isReplicate = prop.getAttributeValue("isReplicate");
                String maxElements = prop.getAttributeValue("maxElements");
                String eternal = prop.getAttributeValue("eternal");
                String timeToIdleSeconds = prop.getAttributeValue("timeToIdle");
                String timeToLiveSeconds = prop.getAttributeValue("timeToLive");
                String supportDisk = prop.getAttributeValue("supportDisk");
                storeLevelMap.put(moduleName + "." + propName, propStoreLevel);
                storeLevelMap.put(moduleName + "." + propName + "." + "autoDegrade", propAutoDegrade);
                storeLevelMap.put(moduleName + "." + propName + "." + "isReplicate", isReplicate);
                storeLevelMap.put(moduleName + "." + propName + "." + "maxElements", maxElements);
                storeLevelMap.put(moduleName + "." + propName + "." + "eternal", eternal);
                storeLevelMap.put(moduleName + "." + propName + "." + "timeToIdleSeconds", timeToIdleSeconds);
                storeLevelMap.put(moduleName + "." + propName + "." + "timeToLiveSeconds", timeToLiveSeconds);
                storeLevelMap.put(moduleName + "." + propName + "." + "supportDisk", supportDisk);
            }
        }
        return storeLevelMap;
    }

    public String getOuterCacheServerType() {
        String serverStr = this.root.getAttributeValue("OuterCacheServerType");
        if (serverStr == null || serverStr.trim().length() == 0) {
            return "ehcache";
        }
        return serverStr;
    }

    public String[] getOuterEhcacheServerList() {
        String serverStr = this.root.getAttributeValue("outerEhcacheServer");
        if (serverStr == null) {
            return null;
        }
        String[] serverArray = serverStr.split(";");
        if (serverArray.length == 0) {
            return null;
        }
        return serverArray;
    }
}

