/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc.express;

import com.kingdee.eas.common.calc.CalcResource;
import com.kingdee.eas.common.calc.IllegalExpressException;
import com.kingdee.eas.common.calc.express.FunctionUtil;
import com.kingdee.eas.common.calc.express.IExpressTraceListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.event.EventListenerList;

public class ExpressAnalyzer {
    private static final FunctionUtil cu = new FunctionUtil();
    private static final int ERROR = -1;
    private static final int END = 0;
    private static final int NUM = 1;
    private static final int PLUS = 2;
    private static final int MINUS = 3;
    private static final int TIMERS = 4;
    private static final int OVER = 5;
    private static final int FRE = 90;
    private static final int STAGE = 96;
    private static final int PERCENT = 97;
    private static final int DYNFUNCTION = 98;
    private static final int FUNCTION = 99;
    private static final int LPAREN = 100;
    private static final int RPAREN = 101;
    private String express;
    private String token;
    private int i;
    private int EXPRESS_LEVEL = 0;
    private EventListenerList listenerList = new EventListenerList();
    private static Properties funcMap = new Properties();

    private ExpressAnalyzer(int exrepssLevel) {
        this.EXPRESS_LEVEL = exrepssLevel;
    }

    public ExpressAnalyzer() {
    }

    public double calculate(String express) throws IllegalExpressException {
        this.i = 0;
        this.express = express.replaceAll("\\s", "").toLowerCase();
        this.debug(CalcResource.getRes("calc_express_colon") + this.express);
        this.checkExpress(this.express);
        return this.express();
    }

    public String getExpress() {
        return this.express;
    }

    private void checkExpress(String s) throws IllegalExpressException {
        if (s == null || s.length() == 0) {
            throw new IllegalExpressException(CalcResource.getRes("express_cannot_empty"));
        }
        if (!s.matches("[\\w\\.\\+\\-\\*/\\^!\\(\\),%#]+")) {
            throw new IllegalExpressException(CalcResource.getRes("express") + "\"" + s + "\"" + CalcResource.getRes("with_illicitly_char"));
        }
        int deep = 0;
        char[] chs = s.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] == '(') {
                ++deep;
            } else if (chs[i] == ')') {
                --deep;
            }
            if (deep >= 0) continue;
            this.error(CalcResource.getRes("parentheses_unmatched"));
        }
        if (deep != 0) {
            throw new IllegalExpressException(CalcResource.getRes("express_parentheses_unmatched") + "(" + CalcResource.getRes("mulit") + Math.abs(deep) + CalcResource.getRes("entries") + (deep < 0 ? CalcResource.getRes("reverse") : CalcResource.getRes("positive")) + CalcResource.getRes("parentheses") + ")");
        }
        boolean validate = true;
        int len = chs.length;
        for (int j = 0; j < len; ++j) {
            if (chs[j] == '(' && j > 0) {
                if (chs[j - 1] == '.' || Character.isDigit(chs[j - 1])) {
                    this.i = j - 1 + 1;
                    validate = false;
                }
            } else if (chs[j] == ')' && j < len - 1 && (chs[j + 1] == '.' || Character.isDigit(chs[j + 1]))) {
                this.i = j + 1 + 1;
                validate = false;
            }
            if (validate) continue;
            this.error(CalcResource.getRes("exrepss_incorrect"));
            break;
        }
    }

    private double express() throws IllegalExpressException {
        double dd = this.term();
        int op = this.getToken();
        while (2 == op || 3 == op) {
            ++this.i;
            double dd2 = this.term();
            switch (op) {
                case 2: {
                    this.debug(dd + "+" + dd2 + "=" + (dd + dd2));
                    dd += dd2;
                    break;
                }
                case 3: {
                    this.debug(dd + "-" + dd2 + "=" + (dd - dd2));
                    dd -= dd2;
                }
            }
            op = this.getToken();
        }
        return dd;
    }

    private double term() throws IllegalExpressException {
        double dd = this.frequency();
        int op = this.getToken();
        while (4 == op || 5 == op) {
            ++this.i;
            double dd2 = this.frequency();
            switch (op) {
                case 4: {
                    this.debug(dd + "*" + dd2 + "=" + dd * dd2);
                    dd *= dd2;
                    break;
                }
                case 5: {
                    this.debug(dd + "/" + dd2 + "=" + dd / dd2);
                    dd /= dd2;
                }
            }
            op = this.getToken();
        }
        return dd;
    }

    private double frequency() throws IllegalExpressException {
        double dd = this.stage();
        int op = this.getToken();
        while (90 == op) {
            ++this.i;
            double dd2 = this.stage();
            this.debug(dd + "^" + dd2 + "=" + Math.pow(dd, dd2));
            dd = Math.pow(dd, dd2);
            op = this.getToken();
        }
        return dd;
    }

    private double stage() throws IllegalExpressException {
        double dd = this.factory();
        int op = this.getToken();
        while (96 == op || 97 == op) {
            ++this.i;
            switch (op) {
                case 96: {
                    int stageValue = (int)Math.round(dd);
                    if (Math.abs(dd - (double)stageValue) > 1.0E-9) {
                        this.warn(CalcResource.getRes("autofix_factorial_radix") + "(" + dd + "->" + stageValue + ")");
                    }
                    try {
                        dd = FunctionUtil.fact((double)stageValue);
                    }
                    catch (Exception e) {
                        this.error(e.getMessage());
                    }
                    this.debug(stageValue + "!=" + dd);
                    break;
                }
                case 97: {
                    this.debug(dd + "%=" + dd / 100.0);
                    dd /= 100.0;
                }
            }
            op = this.getToken();
        }
        return dd;
    }

    private double factory() throws IllegalExpressException {
        double dd = 0.0;
        int op = this.getToken();
        if (op == 3) {
            return 0.0;
        }
        if (1 != op && 100 != op && 98 != op && 99 != op) {
            this.error(CalcResource.getRes("exrepss_incorrect"));
        }
        while (1 == op || 100 == op || 98 == op || 99 == op) {
            ++this.i;
            switch (op) {
                case 1: {
                    dd = Double.parseDouble(this.token);
                    break;
                }
                case 100: {
                    dd = this.express();
                    if (this.getToken() != 101) {
                        this.error(CalcResource.getRes("parentheses_unmatched"));
                        break;
                    }
                    ++this.i;
                    break;
                }
                case 98: {
                    String myFunction = this.parseFunction();
                    this.advanceFuncLPAREN();
                    double param = 0.0;
                    if (this.express.charAt(this.i) != ')') {
                        param = this.express();
                    }
                    this.advanceFuncRPAREN();
                    String body = funcMap.getProperty(myFunction);
                    if (body == null || body.length() == 0) {
                        this.error(CalcResource.getRes("func_undefine"));
                    }
                    dd = this.buildTempCalculator().calculate(this.createFunctionExpress(body, String.valueOf(param)));
                    this.debug(myFunction + "(" + param + ")=" + dd);
                    break;
                }
                case 99: {
                    --this.i;
                    String funcName = this.parseFunction();
                    boolean isDecode = "decode".equals(funcName);
                    List paramsList = this.parseParameters(isDecode);
                    dd = this.invokeFunction(funcName, paramsList);
                    this.debug(funcName + this.listAsFunctionParameterString(paramsList) + "=" + dd);
                }
            }
            op = this.getToken();
        }
        return dd;
    }

    private ExpressAnalyzer buildTempCalculator() {
        ExpressAnalyzer cex = new ExpressAnalyzer(this.EXPRESS_LEVEL + 1);
        cex.listenerList = this.listenerList;
        return cex;
    }

    private double invokeFunction(String name, List paramsList) throws IllegalExpressException {
        block23: {
            try {
                Method m = null;
                if (paramsList.size() == 0) {
                    try {
                        m = FunctionUtil.class.getMethod(name, null);
                        if (m != null) {
                            Object obj = m.invoke((Object)cu, null);
                            return (Double)obj;
                        }
                        break block23;
                    }
                    catch (NoSuchMethodException ex) {
                    }
                    catch (SecurityException ex) {
                    }
                    catch (IllegalAccessException ex) {
                    }
                    catch (IllegalArgumentException ex) {}
                    break block23;
                }
                try {
                    Object[] dbs = new Double[paramsList.size()];
                    for (int i = 0; i < dbs.length; ++i) {
                        dbs[i] = (Double)paramsList.get(i);
                    }
                    Class[] cls = new Class[paramsList.size()];
                    for (int i = 0; i < cls.length; ++i) {
                        cls[i] = Double.TYPE;
                    }
                    m = FunctionUtil.class.getMethod(name, cls);
                    if (m != null) {
                        Object obj = m.invoke((Object)cu, dbs);
                        return (Double)obj;
                    }
                }
                catch (NoSuchMethodException ex) {
                }
                catch (SecurityException ex) {
                }
                catch (IllegalAccessException ex) {
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                if (m != null) break block23;
                try {
                    m = FunctionUtil.class.getMethod(name, List.class);
                    if (m != null) {
                        Object obj = m.invoke((Object)cu, paramsList);
                        return (Double)obj;
                    }
                }
                catch (NoSuchMethodException ex) {
                }
                catch (SecurityException ex) {
                }
                catch (IllegalAccessException ex) {
                }
                catch (IllegalArgumentException ex) {}
            }
            catch (InvocationTargetException ex) {
                this.error(ex.getTargetException().getMessage());
            }
        }
        String errorMsg = CalcResource.getRes("command_error") + name + this.listAsFunctionParameterString(paramsList);
        this.error(errorMsg);
        throw new RuntimeException(errorMsg);
    }

    private String parseFunction() {
        int startPos = this.i;
        String funcName = null;
        while (this.i < this.express.length()) {
            char ch = this.express.charAt(this.i);
            if (ch != '(') {
                ++this.i;
                continue;
            }
            funcName = this.express.substring(startPos, this.i);
            break;
        }
        if (funcName == null) {
            funcName = this.express.substring(startPos);
        }
        return funcName;
    }

    private List parseParameters(boolean isDecode) throws IllegalExpressException {
        int startPos = this.i;
        int parenDeep = 0;
        while (this.i < this.express.length()) {
            char ch = this.express.charAt(this.i);
            ++this.i;
            if (ch == '(') {
                ++parenDeep;
            } else if (ch == ')') {
                --parenDeep;
            }
            if (parenDeep != 0) continue;
            String paramString = this.express.substring(startPos, this.i);
            return this.calculateMultiExpress(paramString, isDecode);
        }
        String errorMsg = CalcResource.getRes("command_error");
        this.error(errorMsg);
        throw new RuntimeException(errorMsg);
    }

    private List calculateMultiExpress(String s, boolean isDecode) throws IllegalExpressException {
        char ch;
        ExpressAnalyzer cee = this.buildTempCalculator();
        ArrayList<Double> valueList = new ArrayList<Double>();
        int parenDeep = 0;
        int lastPos = 0;
        int prefixParenCount = 0;
        for (int i = 0; i < s.length() && (ch = s.charAt(i)) == '('; ++i) {
            ++lastPos;
            ++prefixParenCount;
        }
        int opNumIndex = 0;
        for (int i = lastPos; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (ch == '(') {
                ++parenDeep;
                continue;
            }
            if (ch == ')') {
                --parenDeep;
                continue;
            }
            if (ch != ',' || parenDeep > 0) continue;
            String sub = s.substring(lastPos, i);
            if (isDecode && (opNumIndex == 2 || opNumIndex == 3)) {
                if (opNumIndex == 2) {
                    if ((Double)valueList.get(0) > (Double)valueList.get(1)) {
                        valueList.add(new Double(cee.calculate(sub)));
                    } else {
                        valueList.add(new Double(0.0));
                    }
                }
                if (opNumIndex == 3) {
                    if ((Double)valueList.get(0) > (Double)valueList.get(1)) {
                        valueList.add(new Double(0.0));
                    } else {
                        valueList.add(new Double(cee.calculate(sub)));
                    }
                }
            } else {
                valueList.add(new Double(cee.calculate(sub)));
            }
            ++opNumIndex;
            lastPos = i + 1;
        }
        String sub = s.substring(lastPos, s.length() - prefixParenCount);
        if (sub.length() > 0) {
            valueList.add(new Double(cee.calculate(sub)));
        }
        return valueList;
    }

    private void advanceFuncLPAREN() throws IllegalExpressException {
        if (this.getToken() != 100) {
            this.error(CalcResource.getRes("func_without_parentheses"));
        } else {
            ++this.i;
        }
    }

    private void advanceFuncRPAREN() throws IllegalExpressException {
        if (this.getToken() != 101) {
            this.error(CalcResource.getRes("func_parentheses_unmatched"));
        } else {
            ++this.i;
        }
    }

    private String createFunctionExpress(String body, String param) {
        String key = "\\?";
        String buf = body.replaceAll(key, param);
        this.debug(CalcResource.getRes("func_substitute") + body + "=" + buf);
        return buf;
    }

    private int getToken() throws IllegalExpressException {
        if (this.i >= this.express.length()) {
            return 0;
        }
        char ch = this.express.charAt(this.i);
        if (Character.isDigit(ch)) {
            int j = this.i;
            do {
                ++this.i;
            } while (this.i < this.express.length() && (Character.isDigit(ch = this.express.charAt(this.i)) || ch == '.'));
            this.token = this.express.substring(j, this.i);
            --this.i;
            return 1;
        }
        switch (ch) {
            case '+': {
                return 2;
            }
            case '-': {
                return 3;
            }
            case '*': {
                return 4;
            }
            case '/': {
                return 5;
            }
            case '(': {
                return 100;
            }
            case ')': {
                return 101;
            }
            case '^': {
                return 90;
            }
            case '!': {
                return 96;
            }
            case '%': {
                return 97;
            }
            case '#': {
                return 98;
            }
        }
        if (Character.isLetter(ch)) {
            return 99;
        }
        String errorMsg = CalcResource.getRes("exrepss_incorrect");
        this.error(errorMsg);
        throw new RuntimeException(errorMsg);
    }

    private String listAsFunctionParameterString(List list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int len = list.size();
        if (len > 0) {
            for (int i = 0; i < len - 1; ++i) {
                sb.append(list.get(i)).append(",");
            }
            sb.append(list.get(len - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    private void debug(Object msg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.EXPRESS_LEVEL; ++i) {
            sb.append("    ");
        }
        sb.append("#" + msg + "\n");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IExpressTraceListener.class) continue;
            ((IExpressTraceListener)listeners[i + 1]).debug(sb.toString());
        }
    }

    private void error(Object msg) throws IllegalExpressException {
        StringBuffer sb = new StringBuffer(this.express + "\n");
        for (int j = 0; j < this.i - 1; ++j) {
            sb.append(" ");
        }
        sb.append("^");
        sb.append(msg);
        sb.append(" [" + (this.EXPRESS_LEVEL == 0 ? "" : CalcResource.getRes("nesting_express")) + "~@" + (this.i == 0 ? 1 : this.i) + "]");
        throw new IllegalExpressException(sb.toString());
    }

    private void warn(Object msg) {
        StringBuffer sb = new StringBuffer(CalcResource.getRes("warning") + msg + "\n");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IExpressTraceListener.class) continue;
            ((IExpressTraceListener)listeners[i + 1]).warn(sb.toString());
        }
    }

    public static String getUsage() {
        StringBuffer tip = new StringBuffer();
        tip.append(CalcResource.getRes("op_pri") + "\n").append("1.()    2.! %    3.^(" + CalcResource.getRes("op_power") + ")    4.* /    5.+ -\n");
        tip.append(CalcResource.getRes("func_category") + "\n");
        tip.append("1." + CalcResource.getRes("numeric_trigonometric_func") + "abs,acos,asin,atan,ceil,cos,dms,exp,floor,log,max,min,mod,pow,round,sin,sqrt,tan,toDegrees,toRadians\n");
        tip.append("2." + CalcResource.getRes("date_func") + "year(),month(),day(),hour(),minute(),second(),week(),timestamp()\n");
        tip.append("3." + CalcResource.getRes("logistic_func") + "sign,decode\n");
        tip.append("4." + CalcResource.getRes("statistical_func") + "avg,sum,sumsq\n");
        tip.append("5." + CalcResource.getRes("finance_func") + "db,ddb,npv,sln,syd\n");
        tip.append("6." + CalcResource.getRes("other_func") + "fact," + CalcResource.getRes("const") + "PI(),trunc\n");
        tip.append(CalcResource.getRes("selfdefine_func") + "(" + CalcResource.getRes("with") + "#" + CalcResource.getRes("ahead_as_id") + ")\n");
        Enumeration<Object> em = funcMap.keys();
        int n = 0;
        while (em.hasMoreElements()) {
            String key = (String)em.nextElement();
            tip.append(++n + "." + key + "=" + funcMap.getProperty(key) + "\n");
        }
        tip.append(CalcResource.getRes("shortcut_key") + "(" + CalcResource.getRes("cursor_shouldbe_input_area") + ")");
        tip.append("F1" + CalcResource.getRes("colon_help") + "\n");
        tip.append("Ctrl+Enter " + CalcResource.getRes("or") + "Alt+Enter " + CalcResource.getRes("or") + "Shift+Enter " + CalcResource.getRes("or") + "=" + CalcResource.getRes("colon_calculate") + "\n");
        tip.append("Alt+Up" + CalcResource.getRes("colon_pre_step") + "\n");
        tip.append("Alt+Down" + CalcResource.getRes("colon_next_step") + "/" + CalcResource.getRes("new_input") + "\n");
        return tip.toString();
    }

    public void addCalculateExpressListener(IExpressTraceListener l) {
        this.listenerList.add(IExpressTraceListener.class, l);
    }

    public void removeCalculateExpressListener(IExpressTraceListener l) {
        this.listenerList.remove(IExpressTraceListener.class, l);
    }

    private void fireDisplayChange() {
    }

    public static void main(String[] args) {
        try {
            ExpressAnalyzer cex = new ExpressAnalyzer();
            double dd = cex.calculate("DDB(2400,300,120,1,2)");
            System.out.println(CalcResource.getRes("calc_result") + "\uff1d" + dd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            funcMap.load(ExpressAnalyzer.class.getResourceAsStream("function.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

