/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.XMLDAO;
import com.kingdee.bos.dao.xml.XMLStore;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.rule.RuleInfo;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.utils.XMLLoaderImpl;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jdom.Element;

public class XMLStoreHelper {
    private XMLStore xmlStore;
    private Context ctx;
    private BOSObjectType bosType;

    public XMLStoreHelper(Context ctx) throws DataAccessException {
        this.ctx = ctx;
        this.xmlStore = new XMLStore(ctx);
        this.xmlStore.xmlLoader = new XMLLoaderImpl(ctx);
    }

    public IObjectValue load(InputStream is) throws DataAccessException {
        return this.xmlStore.xmlLoader.load(this.bosType, is);
    }

    public boolean equals(Object obj) {
        return this.xmlStore.equals(obj);
    }

    public Element generate(BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        return this.xmlStore.generate(bosType, ov);
    }

    public int hashCode() {
        return this.xmlStore.hashCode();
    }

    public void store(BOSObjectType bosType, IObjectValue ov, OutputStream os) throws DataAccessException {
        this.xmlStore.store(bosType, ov, os);
    }

    public void store(BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        this.xmlStore.store(bosType, ov);
    }

    public void storeResource(BOSObjectType bosType, IObjectPK pk, Map hash) throws DataAccessException {
        this.xmlStore.storeResource(bosType, pk, hash);
    }

    public void storeResource(InputStream is, OutputStream os, Map hash) throws DataAccessException {
        this.xmlStore.storeResource(is, os, hash);
    }

    public String toString() {
        return this.xmlStore.toString();
    }

    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        if (this.bosType.equals((Object)MetaDataTypeList.ENTITY) || this.bosType.equals((Object)MetaDataTypeList.FACADE)) {
            XMLStoreHelper.fillBusinessObject((BusinessObjectInfo)ov);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.RULE)) {
            XMLStoreHelper.compileRule(this.ctx, (RuleInfo)ov);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.PERMISSION)) {
            this.fillPermissionID(this.ctx, (PermissionInfo)ov);
        }
        this.store(ov.getBOSType(), ov, os);
    }

    protected void fillPermissionID(Context ctx, PermissionInfo ov) {
        PermissionItemCollection its = ov.getPermissionItems();
        for (int i = 0; i < its.size(); ++i) {
            PermissionItemInfo pm = its.get(i);
            BizRefCollection brs = pm.getBizRefs();
            for (int j = 0; j < brs.size(); ++j) {
                BizRefInfo br = brs.get(j);
                if (!StringUtils.isEmpty((String)br.getString("id"))) continue;
                br.setString("id", Uuid.create().toString());
            }
        }
    }

    public static void fillBusinessObject(BusinessObjectInfo bo) {
        XMLDAO.fillBusinessObject((BusinessObjectInfo)bo);
    }

    public static void compileRule(Context ctx, RuleInfo rule) {
        XMLDAO.compileRule((Context)ctx, (RuleInfo)rule);
    }

    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public void setBosType(BOSObjectType bosType) {
        this.bosType = bosType;
    }
}

