/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.common.client.LocaleUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.AdvMsgBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

class BgPanel
extends KDPanel {
    protected Image bgImg;
    protected String msg;
    protected Vector lines;
    protected static final int lineHeight = 15;
    protected static final int x = 150;
    protected static final int y = 28;
    protected static final int maxWidth = 255;
    protected static final int normalLine = 8;
    protected static final int maxLine = 26;
    protected static final int imageWidth = 429;
    protected static final int imageHeight = 138;
    protected static final Color extMsgBgColor = new Color(242, 242, 242);

    public BgPanel(Image bgImg, String msg) {
        this.bgImg = bgImg;
        this.msg = msg;
        this.setBackground(extMsgBgColor);
        this.setPreferredSize(new Dimension(429, 165));
        if (msg != null && !msg.equals("")) {
            this.initLines();
        }
    }

    protected void initStringArray() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String paragraphString = null;
        boolean isChinese = false;
        boolean isEnglish = false;
        String language = null;
        try {
            language = LocaleUtil.getOriginalLocale(SysContext.getSysContext().getLocale()).getLanguage();
        }
        catch (Throwable t) {
            language = Locale.getDefault().getLanguage();
        }
        if (language != null && language.equalsIgnoreCase("zh")) {
            isChinese = true;
        }
        if (language != null && language.equalsIgnoreCase("en")) {
            this.msg = this.handleEnglishTxt(this.msg);
            isEnglish = true;
        }
        StringTokenizer st = new StringTokenizer(this.msg, "\n");
        this.lines = new Vector(26);
        StringBuffer lineString = null;
        while (st.hasMoreTokens() && this.lines.size() < 26) {
            paragraphString = st.nextToken().trim();
            System.out.println(paragraphString);
            paragraphString = isChinese ? "\u3000\u3000" + paragraphString : "  " + paragraphString;
            lineString = new StringBuffer();
            int lineLength = 0;
            if (isEnglish) {
                lineString = lineString.append(paragraphString);
            } else {
                for (int i = 0; i < paragraphString.length() && this.lines.size() < 26; ++i) {
                    char word = paragraphString.charAt(i);
                    if ((lineLength += fontMetrics.charWidth(word)) < 255) {
                        lineString.append(word);
                        continue;
                    }
                    lineString.append(word);
                    this.lines.add(lineString);
                    lineString = new StringBuffer();
                    lineLength = 0;
                }
            }
            this.lines.add(lineString);
        }
        String lastLineStr = this.lines.get(this.lines.size() - 1).toString();
        if (lastLineStr.trim().length() == 1 && "!,.?\uff01\uff0c\u3002\uff1f".indexOf(lastLineStr.trim()) != -1) {
            this.lines.remove(this.lines.size() - 1);
            AdvMsgBox.logger.info((Object)("new line just one char, remove it . this char is:" + lastLineStr.trim()));
        }
        if (this.lines.size() > 9 && this.lines.size() < 27) {
            int actHeight = this.lines.size() * 15;
            this.setPreferredSize(new Dimension(429, actHeight));
        } else if (this.lines.size() > 26) {
            this.setPreferredSize(new Dimension(429, 390));
        }
    }

    protected void initLines() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String paragraphString = null;
        StringTokenizer st = new StringTokenizer(this.msg, "\n");
        this.lines = new Vector(26);
        while (st.hasMoreTokens() && this.lines.size() < 26) {
            paragraphString = st.nextToken().trim();
            System.out.println(paragraphString);
            StringBuilder lineSb = new StringBuilder();
            int lineWidth = 0;
            boolean firstLineInParagraph = true;
            for (int i = 0; i < paragraphString.length(); ++i) {
                char c = paragraphString.charAt(i);
                lineSb.append(c);
                if ((lineWidth += fontMetrics.charWidth(c)) > 255) {
                    String line = lineSb.toString();
                    if (BgPanel.isInWord(line.toString(), line.length() - 1)) {
                        int breakIndex = this.getPreWordBreak(line, line.length() - 1);
                        String lineToAdd = line.substring(0, breakIndex);
                        this.lines.add(lineToAdd);
                        lineSb = new StringBuilder(line.substring(breakIndex));
                    } else {
                        this.lines.add(lineSb.substring(0, lineSb.length() - 1));
                        lineSb = new StringBuilder(lineSb.substring(lineSb.length() - 1));
                    }
                    lineWidth = 0;
                    for (int j = 0; j < lineSb.length(); ++j) {
                        lineWidth += fontMetrics.charWidth(lineSb.charAt(j));
                    }
                }
                if (!firstLineInParagraph && lineSb.length() >= 2 && lineSb.charAt(0) == ' ' && lineSb.charAt(1) != ' ') {
                    lineSb = new StringBuilder(lineSb.substring(1));
                    lineWidth -= fontMetrics.charWidth(' ');
                }
                firstLineInParagraph = false;
            }
            if (lineSb.length() <= 0) continue;
            this.lines.add(lineSb.toString());
        }
        String lastLineStr = this.lines.get(this.lines.size() - 1).toString();
        if (lastLineStr.trim().length() == 1 && "!,.?\uff01\uff0c\u3002\uff1f".indexOf(lastLineStr.trim()) != -1) {
            this.lines.remove(this.lines.size() - 1);
            AdvMsgBox.logger.info((Object)("new line just one char, remove it . this char is:" + lastLineStr.trim()));
        }
        if (this.lines.size() > 9 && this.lines.size() < 27) {
            int actHeight = this.lines.size() * 15;
            this.setPreferredSize(new Dimension(429, actHeight));
        } else if (this.lines.size() > 26) {
            this.setPreferredSize(new Dimension(429, 390));
        }
    }

    protected String handleEnglishTxt(String str) {
        String msg = "";
        String paragraphString = "";
        StringTokenizer st = new StringTokenizer(str, "\n");
        while (st.hasMoreTokens()) {
            paragraphString = this.handleEnglishStr(st.nextToken().trim());
            if (msg.length() > 0) {
                msg = msg + "\n" + paragraphString;
                continue;
            }
            msg = paragraphString;
        }
        return msg;
    }

    protected String handleEnglishStr(String str) {
        int charNumPerLine = 40;
        StringBuffer ret = new StringBuffer();
        int len = str.length();
        int start = 0;
        int end = 0;
        ArrayList<Integer> indexArr = new ArrayList<Integer>();
        while ((end = start + charNumPerLine) <= len - 1) {
            String line = str.substring(start, end);
            int index = line.lastIndexOf(" ");
            if (index == -1) {
                index = charNumPerLine;
            }
            indexArr.add(new Integer(index + start));
            start += index + 1;
        }
        int s = 0;
        int e = 0;
        int size = indexArr.size();
        for (int i = 0; i < size; ++i) {
            s = 0;
            if (i > 0) {
                s = (Integer)indexArr.get(i - 1);
            }
            e = (Integer)indexArr.get(i);
            String temp = str.substring(s, e);
            ret.append(temp + "\n");
        }
        ret.append(str.substring(e));
        return ret.toString();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.bgImg, 0, 0, this.getSize().width, 138, (ImageObserver)((Object)this));
        if (this.lines != null) {
            for (int i = 0; i < this.lines.size(); ++i) {
                g.drawString(this.lines.elementAt(i).toString(), 150, 28 + i * 15);
            }
        }
    }

    private static boolean isInWord(String source, int index) {
        if (index <= 0 || index >= source.length()) {
            return false;
        }
        char c = source.charAt(index);
        char pc = source.charAt(index - 1);
        if (BgPanel.isCJKCharacter(pc)) {
            return BgPanel.isPunctuation(c);
        }
        if (BgPanel.isCJKCharacter(c)) {
            return false;
        }
        return !Character.isWhitespace(c) && !Character.isWhitespace(pc);
    }

    private int getPreWordBreak(String line, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (BgPanel.isInWord(line, i)) continue;
            return i;
        }
        return fromIndex;
    }

    private static boolean isPunctuation(char c) {
        int type = Character.getType(c);
        HashSet<Integer> punctuationTypes = new HashSet<Integer>();
        punctuationTypes.add(23);
        punctuationTypes.add(20);
        punctuationTypes.add(22);
        punctuationTypes.add(30);
        punctuationTypes.add(29);
        punctuationTypes.add(24);
        punctuationTypes.add(21);
        boolean isPunctuation = punctuationTypes.contains(type);
        return isPunctuation;
    }

    private static boolean isCJKCharacter(char c) {
        Character.UnicodeBlock[] cjkBlocks;
        int[][] cjkUnicodeRanges;
        for (int[] range : cjkUnicodeRanges = new int[][]{{12288, 40959}, {11904, 12031}, {12032, 12245}, {11904, 12019}, {63744, 64217}, {59413, 59503}, {58368, 58856}, {58880, 59087}, {12272, 12287}, {65040, 65055}, {44032, 55215}, {4352, 4607}}) {
            if (range[0] > c || c > range[1]) continue;
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        for (Character.UnicodeBlock cjkBlock : cjkBlocks = new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_COMPATIBILITY, Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B}) {
            if (!cjkBlock.equals(unicodeBlock)) continue;
            return true;
        }
        return false;
    }
}

