/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.eas.util.client.DataLimitExceedExceptionHandler;
import com.kingdee.eas.util.client.IExceptionHandler;
import java.util.Hashtable;
import java.util.Map;

public class ExceptionHandlerFactory {
    public static final Map cacheHandler = new Hashtable();

    public static IExceptionHandler getHandler(Throwable exc) {
        IExceptionHandler handler = null;
        if (exc instanceof DataLimitExceedException) {
            handler = (IExceptionHandler)cacheHandler.get(DataLimitExceedExceptionHandler.class.getName());
            if (handler == null) {
                handler = new DataLimitExceedExceptionHandler();
                cacheHandler.put(DataLimitExceedExceptionHandler.class.getName(), handler);
            }
            return handler;
        }
        if (exc instanceof BOSException && exc.getCause() instanceof DataLimitExceedException) {
            handler = (IExceptionHandler)cacheHandler.get(DataLimitExceedExceptionHandler.class.getName());
            if (handler == null) {
                handler = new DataLimitExceedExceptionHandler();
                cacheHandler.put(DataLimitExceedExceptionHandler.class.getName(), handler);
            }
            return handler;
        }
        return handler;
    }
}

