/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.encryptalgorithm;

import com.kingdee.eas.util.encryptalgorithm.Base64;
import com.kingdee.eas.util.encryptalgorithm.Rijndael_Algorithm;
import java.security.InvalidKeyException;

public class Rijndael_Util {
    public static final int DEFAULT_BLOCK_SIZE = 16;

    public static final int getInt(byte[] bytes, int offSet) {
        return (bytes[offSet + 0] & 0xFF) << 24 | bytes[offSet + 1] << 16 | (bytes[offSet + 2] & 0xFF) << 8 | (bytes[offSet + 3] & 0xFF) << 0;
    }

    public static final void putInt(int val, byte[] bytes, int offSet) {
        bytes[offSet] = (byte)(val >> 24);
        bytes[offSet + 1] = (byte)(val >> 16);
        bytes[offSet + 2] = (byte)(val >> 8);
        bytes[offSet + 3] = (byte)val;
    }

    public static String byte2String(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(bytes[i]);
        }
        return buff.toString();
    }

    public static byte[] make_kb_16(String strKey) {
        return Rijndael_Util.make_kb(strKey, 16);
    }

    public static byte[] make_kb_24(String strKey) {
        return Rijndael_Util.make_kb(strKey, 24);
    }

    public static byte[] make_kb_32(String strKey) {
        return Rijndael_Util.make_kb(strKey, 32);
    }

    private static byte[] make_kb(String strKey, int size) {
        byte[] bytes;
        byte[] kb = new byte[size];
        System.arraycopy(bytes, 0, kb, 0, (bytes = strKey.getBytes()).length > size ? size : bytes.length);
        return kb;
    }

    public static String encode(String key, String strData) throws InvalidKeyException {
        byte[] kb = Rijndael_Util.make_kb_32(key);
        byte[] pt = strData.getBytes();
        byte[] ct = Rijndael_Util.encode(kb, pt, 16);
        return Base64.encodeBytes(ct);
    }

    public static String encode(String key, String strData, int blockSize) throws InvalidKeyException {
        byte[] kb = Rijndael_Util.make_kb_32(key);
        byte[] pt = strData.getBytes();
        byte[] ct = Rijndael_Util.encode(kb, pt, blockSize);
        return Base64.encodeBytes(ct);
    }

    public static String encode(byte[] kb, String data) throws InvalidKeyException {
        byte[] pt = data.getBytes();
        byte[] ct = Rijndael_Util.encode(kb, pt, 16);
        return Base64.encodeBytes(ct);
    }

    public static String decode(String key, String strData) throws InvalidKeyException {
        byte[] kb = Rijndael_Util.make_kb_32(key);
        byte[] ct = Base64.decode(strData);
        byte[] cpt = Rijndael_Util.decode(kb, ct, 16);
        return new String(cpt);
    }

    public static String decode(byte[] kb, String strData) throws InvalidKeyException {
        byte[] ct = Base64.decode(strData);
        byte[] cpt = Rijndael_Util.decode(kb, ct, 16);
        return new String(cpt);
    }

    public static String decode(String key, String strData, int blockSize) throws InvalidKeyException {
        byte[] kb = Rijndael_Util.make_kb_32(key);
        byte[] ct = Base64.decode(strData);
        byte[] cpt = Rijndael_Util.decode(kb, ct, blockSize);
        return new String(cpt);
    }

    public static byte[] encode(byte[] kb, byte[] pt) throws InvalidKeyException {
        return Rijndael_Util.encode(kb, pt, 16);
    }

    public static byte[] encode(byte[] kb, byte[] pt, int blockSize) throws InvalidKeyException {
        Object key = Rijndael_Algorithm.makeKey(kb, blockSize);
        int dataLength = pt.length;
        int mode = dataLength % blockSize;
        byte[] ct = new byte[mode == 0 ? pt.length : 8 + dataLength + blockSize - mode];
        for (int i = 0; i < dataLength; i += blockSize) {
            int restDataLength = dataLength - i;
            if (restDataLength >= blockSize) {
                byte[] block_ct = Rijndael_Algorithm.blockEncrypt(pt, i, key, blockSize);
                System.arraycopy(block_ct, 0, ct, i, blockSize);
                continue;
            }
            if (blockSize == 16 || blockSize == 24) {
                Object last_block_key = Rijndael_Algorithm.makeKey(kb, blockSize + 8);
                byte[] block_pt = new byte[blockSize + 8];
                System.arraycopy(pt, i, block_pt, 0, restDataLength);
                Rijndael_Util.putInt(dataLength, block_pt, blockSize);
                byte[] block_ct = Rijndael_Algorithm.blockEncrypt(block_pt, 0, last_block_key, blockSize + 8);
                System.arraycopy(block_ct, 0, ct, i, blockSize + 8);
                continue;
            }
            Object key_16 = Rijndael_Algorithm.makeKey(kb, 16);
            byte[] block_24_pt = new byte[24];
            if (restDataLength > 16) {
                byte[] block_16_ct = Rijndael_Algorithm.blockEncrypt(pt, i, key_16, 16);
                System.arraycopy(block_16_ct, 0, ct, i, 16);
                System.arraycopy(pt, i + 16, block_24_pt, 0, restDataLength -= 16);
            } else {
                byte[] block_pt = new byte[16];
                System.arraycopy(pt, i, block_pt, 0, restDataLength);
                byte[] block_16_ct = Rijndael_Algorithm.blockEncrypt(block_pt, 0, key_16, 16);
                System.arraycopy(block_16_ct, 0, ct, i, 16);
            }
            Object key_24 = Rijndael_Algorithm.makeKey(kb, 24);
            Rijndael_Util.putInt(dataLength, block_24_pt, 16);
            byte[] block_24_ct = Rijndael_Algorithm.blockEncrypt(block_24_pt, 0, key_24, 24);
            System.arraycopy(block_24_ct, 0, ct, i + 16, 24);
        }
        return ct;
    }

    public static byte[] decode(byte[] kb, byte[] ct) throws InvalidKeyException {
        return Rijndael_Util.decode(kb, ct, 16);
    }

    public static byte[] decode(byte[] kb, byte[] ct, int blockSize) throws InvalidKeyException {
        byte[] pt;
        int mode = ct.length % blockSize;
        Object key = Rijndael_Algorithm.makeKey(kb, blockSize);
        if (mode == 0) {
            pt = new byte[ct.length];
            for (int i = 0; i < ct.length; i += blockSize) {
                byte[] block_pt = Rijndael_Algorithm.blockDecrypt(ct, i, key, blockSize);
                System.arraycopy(block_pt, 0, pt, i, blockSize);
            }
        } else {
            int dataLength;
            if (blockSize == 16 || blockSize == 24) {
                Object first_key = Rijndael_Algorithm.makeKey(kb, blockSize + 8);
                byte[] last_block_pt = Rijndael_Algorithm.blockDecrypt(ct, ct.length - blockSize - 8, first_key, blockSize + 8);
                dataLength = Rijndael_Util.getInt(last_block_pt, blockSize);
                pt = new byte[dataLength];
                System.arraycopy(last_block_pt, 0, pt, ct.length - blockSize - 8, dataLength % blockSize);
            } else {
                Object key_24 = Rijndael_Algorithm.makeKey(kb, 24);
                byte[] last_block_24_pt = Rijndael_Algorithm.blockDecrypt(ct, ct.length - 24, key_24, 24);
                dataLength = Rijndael_Util.getInt(last_block_24_pt, 16);
                pt = new byte[dataLength];
                if (dataLength > ct.length - 24) {
                    System.arraycopy(last_block_24_pt, 0, pt, ct.length - 24, dataLength - (ct.length - 24));
                }
                Object key_16 = Rijndael_Algorithm.makeKey(kb, 16);
                byte[] last_block_16_pt = Rijndael_Algorithm.blockDecrypt(ct, ct.length - 24 - 16, key_16, 16);
                if (pt.length > ct.length - 24) {
                    System.arraycopy(last_block_16_pt, 0, pt, ct.length - 24 - 16, 16);
                } else {
                    System.arraycopy(last_block_16_pt, 0, pt, ct.length - 24 - 16, pt.length - (ct.length - 24 - 16));
                }
            }
            for (int i = 0; i < ct.length - blockSize - 8; i += blockSize) {
                byte[] block_pt = Rijndael_Algorithm.blockDecrypt(ct, i, key, blockSize);
                System.arraycopy(block_pt, 0, pt, i, blockSize);
            }
        }
        return pt;
    }

    public static void main(String[] args) {
        String user = "kSTEf00p24SN6Ca0iSecgFFN2h83TflJphSzkShjy+f4p1i/UYZXPBFzyDR5CcY3akme9h3wYJm3khWR29qCZW8G9g2N+D/";
        String pwd = "00000004784282683";
        try {
            String lres = Rijndael_Util.decode(pwd, user);
            if (pwd.equals(lres)) {
                System.out.println("lres is:" + lres);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

