/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class ObjectValueForEditUIUtil
extends ObjectValueUtil {
    public static boolean objectValueEquals(AbstractObjectValue source, AbstractObjectValue target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!source.getBOSType().equals((Object)target.getBOSType())) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(source.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (ObjectValueForEditUIUtil.ownPropertyEquals(source, target, (OwnPropertyInfo)property)) continue;
                return false;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = ObjectValueForEditUIUtil.isComposite(entity, (LinkPropertyInfo)property);
            if (ObjectValueForEditUIUtil.isAggregation(entity, (LinkPropertyInfo)property, source)) {
                AbstractObjectCollection sourceChildCollection = (AbstractObjectCollection)source.get(property.getName());
                AbstractObjectCollection targetChildCollection = (AbstractObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    AbstractObjectValue sourceChildObject = (AbstractObjectValue)sourceChildCollection.getObject(i);
                    AbstractObjectValue targetChildObject = (AbstractObjectValue)targetChildCollection.getObject(i);
                    if (!(composite ? !ObjectValueForEditUIUtil.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueForEditUIUtil.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            AbstractObjectValue sourceChildObject = (AbstractObjectValue)source.get(property.getName());
            AbstractObjectValue targetChildObject = (AbstractObjectValue)target.get(property.getName());
            if (!(composite ? !ObjectValueForEditUIUtil.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueForEditUIUtil.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    private static boolean objectValueEqualsPk(AbstractObjectValue source, AbstractObjectValue target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            Object sourceId = source.get(source.getPKField());
            Object targetId = target.get(target.getPKField());
            if (sourceId == null && targetId == null) {
                return true;
            }
            if (sourceId != null && targetId != null) {
                return sourceId.toString().equals(targetId.toString());
            }
            return false;
        }
        return false;
    }

    private static boolean isAggregation(EntityObjectInfo entity, LinkPropertyInfo property, AbstractObjectValue source) {
        return source.get(property.getName()) instanceof AbstractObjectCollection;
    }

    private static boolean isComposite(EntityObjectInfo entity, LinkPropertyInfo property) {
        return property.getRelationship().getType().equals((Object)RelationshipType.COMPOSITION) && property.getRelationship().getClientObject().getType().equals((Object)entity.getType());
    }

    protected static boolean ownPropertyEquals(AbstractObjectValue source, AbstractObjectValue target, OwnPropertyInfo property) {
        if (property.getDataType().equals((Object)DataType.SHORT)) {
            short targetProperty;
            short sourceProperty = source.getShort(property.getName());
            return sourceProperty == (targetProperty = target.getShort(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.INTEGER)) {
            int targetProperty;
            int sourceProperty = source.getInt(property.getName());
            return sourceProperty == (targetProperty = target.getInt(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.LONG)) {
            long targetProperty;
            long sourceProperty = source.getLong(property.getName());
            return sourceProperty == (targetProperty = target.getLong(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.FLOAT)) {
            float targetProperty;
            float sourceProperty = source.getFloat(property.getName());
            return sourceProperty == (targetProperty = target.getFloat(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DOUBLE)) {
            double targetProperty;
            double sourceProperty = source.getDouble(property.getName());
            return sourceProperty == (targetProperty = target.getDouble(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.ENUM)) {
            Object sourceobj = source.get(property.getName());
            Object targetObj = target.get(property.getName());
            if (sourceobj != null) {
                return sourceobj.equals(targetObj);
            }
            if (targetObj != null) {
                return targetObj.equals(sourceobj);
            }
            return true;
        }
        if (property.getDataType().equals((Object)DataType.BOOLEAN)) {
            boolean targetProperty;
            boolean sourceProperty = source.getBoolean(property.getName());
            return sourceProperty == (targetProperty = target.getBoolean(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.BYTE)) {
            byte targetProperty;
            byte sourceProperty = source.getByte(property.getName());
            return sourceProperty == (targetProperty = target.getByte(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DECIMAL)) {
            BigDecimal sourceProperty = source.getBigDecimal(property.getName());
            BigDecimal targetProperty = target.getBigDecimal(property.getName());
            return ObjectValueForEditUIUtil.bigDecimalEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.STRING)) {
            String sourceProperty = source.getString(property.getName());
            String targetProperty = target.getString(property.getName());
            return ObjectValueForEditUIUtil.stringEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BYTEARRAY)) {
            byte[] sourceProperty = source.getBytes(property.getName());
            byte[] targetProperty = target.getBytes(property.getName());
            return ObjectValueForEditUIUtil.byteArrayEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.DATE)) {
            java.sql.Date sourceProperty = source.getDate(property.getName());
            java.sql.Date targetProperty = target.getDate(property.getName());
            return ObjectValueForEditUIUtil.dateObjectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIME)) {
            Time sourceProperty = source.getTime(property.getName());
            Time targetProperty = target.getTime(property.getName());
            return ObjectValueForEditUIUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIMESTAMP)) {
            Timestamp sourceProperty = source.getTimestamp(property.getName());
            Timestamp targetProperty = target.getTimestamp(property.getName());
            return ObjectValueForEditUIUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.CHAR)) {
            Character sourceProperty = (Character)source.get(property.getName());
            Character targetProperty = (Character)target.get(property.getName());
            return ObjectValueForEditUIUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BOSUUID)) {
            BOSUuid sourceProperty = source.getBOSUuid(property.getName());
            BOSUuid targetProperty = target.getBOSUuid(property.getName());
            return ObjectValueForEditUIUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.UUID)) {
            Uuid sourceProperty = source.getUuid(property.getName());
            Uuid targetProperty = target.getUuid(property.getName());
            return ObjectValueForEditUIUtil.objectEquals(sourceProperty, targetProperty);
        }
        Object sourceProperty = source.get(property.getName());
        Object targetProperty = target.get(property.getName());
        return ObjectValueForEditUIUtil.objectEquals(sourceProperty, targetProperty);
    }

    private static boolean dateObjectEquals(Object source, Object target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            Date sd = (Date)source;
            Date td = (Date)target;
            return sd.getYear() == td.getYear() && sd.getMonth() == td.getMonth() && sd.getDay() == td.getDay();
        }
        return false;
    }
}

