/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.uiframe.utils.StringUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.app.AbstractDataBaseControllerBean;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Connection;

public class DataBaseControllerBean
extends AbstractDataBaseControllerBean {
    private static final String SHARE_TYPE_NAME = "controlType";
    private String controlType = null;
    private static final String BOTP_BIZ_REFERENCE = "com.kingdee.bos.metadata.bot.BOTPReference";

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = null;
        dataBaseInfo = (DataBaseInfo)model;
        this.setNumberFromCodingRule(ctx, dataBaseInfo, this.getCurrentOrgId(ctx, (IObjectValue)dataBaseInfo));
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        super._addnew(ctx, pk, (IObjectValue)dataBaseInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = null;
        dataBaseInfo = (DataBaseInfo)model;
        this.setNumberFromCodingRule(ctx, dataBaseInfo, this.getCurrentOrgId(ctx));
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        return super._addnew(ctx, (IObjectValue)dataBaseInfo);
    }

    @Override
    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String name = dataBaseInfo.getName();
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    @Override
    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterCU;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (this.getControlType(ctx, dataBaseInfo).equals("") && FilterUtility.hasFilterItem(filterCU = this.getFilterForDefaultCU(ctx, model))) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    private String getControlType(Context ctx, DataBaseInfo info) throws BOSException {
        if (this.controlType != null) {
            return this.controlType;
        }
        this.controlType = "";
        EntityObjectInfo eoi = this.getBOSEntity(ctx, info);
        boolean hasShareType = false;
        hasShareType = eoi.containsExtendedPropertyKey(SHARE_TYPE_NAME);
        if (hasShareType) {
            this.controlType = eoi.getExtendedProperty(SHARE_TYPE_NAME);
        } else if (eoi.getBaseEntity().getName().equals("DataBaseD")) {
            this.controlType = "D";
        }
        return this.controlType;
    }

    @Override
    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterCU;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getControlType(ctx, dataBaseInfo).equals("") && FilterUtility.hasFilterItem(filterCU = this.getFilterForDefaultCU(ctx, model))) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        DataBaseInfo info = (DataBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ctx, info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        return this.getFilterForDefaultCU(model);
    }

    protected FilterInfo getFilterForDefaultCU(IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        DataBaseInfo info = (DataBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ContextUtils.getContextFromSession(), info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        if (caller.getClass().getPackage().getName().toLowerCase().indexOf("com.kingdee.eas.basedata.assistant") < 0 && caller.getClass().getPackage().getName().toLowerCase().indexOf("com.kingdee.eas.basedata.master") < 0) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = this.getNextCompanyId(ctx);
        }
        if (orgId == null || orgId.trim().length() == 0) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId) && !iCodingRuleManager.isUserSelect((IObjectValue)caller, orgId)) {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            } else if (iCodingRuleManager.isAddView((IObjectValue)caller, orgId)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)caller, orgId)) {
                    iCodingRuleManager.checkModifiedNumber((IObjectValue)caller, orgId, caller.getNumber().toString());
                }
            } else {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            }
        }
    }

    protected String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo comInfo = this.getRootOrgInCUNew(ctx);
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    private CompanyOrgUnitInfo getRootOrgInCUNew(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo rootCompany = null;
        String pkId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        ObjectUuidPK pk = new ObjectUuidPK(pkId);
        CtrlUnitInfo rootCUInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk);
        if (rootCUInfo.isIsCompanyOrgUnit()) {
            rootCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        return rootCompany;
    }

    protected String getCurrentOrgId(Context ctx) {
        String OrgUnitId = null;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (company != null && company.getId() != null) {
            OrgUnitId = company.getId().toString();
        }
        return OrgUnitId;
    }

    protected final String getCurrentOrgIdForOrgType(Context ctx) {
        String OrgUnitId = null;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (company != null && company.getId() != null) {
            OrgUnitId = company.getId().toString();
        }
        return OrgUnitId;
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DataBaseInfo dataBase = this.getDataBaseInfo(ctx, pk);
        this.recycleNumberFromCodingRule(ctx, dataBase, this.getCurrentOrgId(ctx, (IObjectValue)dataBase));
        super._delete(ctx, pk);
    }

    protected void recycleNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        if (caller.getClass().getPackage().getName().toLowerCase().indexOf("com.kingdee.eas.basedata.assistant") < 0 && caller.getClass().getPackage().getName().toLowerCase().indexOf("com.kingdee.eas.basedata.master") < 0) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId)) {
                iCodingRuleManager.recycleNumber((IObjectValue)caller, orgId, caller.getNumber());
            }
        } else {
            String root = this.getNextCompanyId(ctx);
            if (root != null && root.trim().length() > 0 && iCodingRuleManager.isExist((IObjectValue)caller, root) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, root)) {
                iCodingRuleManager.recycleNumber((IObjectValue)caller, root, caller.getNumber());
            }
        }
    }

    protected String _getPropertyAlias(Context ctx, DataBaseInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    @Override
    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        super._isReferenced(ctx, pk, cn);
        if (pk instanceof ObjectUuidPK) {
            try {
                IBizReference botpReference = this.getBOTPBizReference();
                if (botpReference != null && botpReference.checkReferenced(ctx, ((ObjectUuidPK)pk).getKeyValue()).isFound()) {
                    BizReference bizReference = new BizReference();
                    bizReference.setRefEntityAlias_L1("BOTP Rule");
                    bizReference.setRefEntityAlias_L2("BOTP Rule");
                    bizReference.setRefEntityAlias_L3("BOTP Rule");
                    throw new ObjectReferedException((Object)bizReference);
                }
            }
            catch (BizReferenceException exc) {
                // empty catch block
            }
        }
    }

    protected IBizReference getBOTPBizReference() {
        IBizReference result = null;
        try {
            result = (IBizReference)Class.forName(BOTP_BIZ_REFERENCE).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected String _getFullDisplayName(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String fullDisplayName = "";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        DataBaseInfo data = this.getDataBaseInfo(ctx, pk, selector);
        fullDisplayName = data.getName();
        return fullDisplayName;
    }

    protected final String getCurrentOrgId(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CoreBaseInfo info = (CoreBaseInfo)model;
        if (info == null || info.getId() == null) {
            return null;
        }
        OrgUnitInfo org = this.getCurrentOrgUnitForType(ctx, info);
        if (org == null) {
            return null;
        }
        String orgId = org.getId().toString();
        return orgId;
    }

    @Override
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DataBaseInfo info = (DataBaseInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }

    @Override
    protected String _getLogInfo(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        String pkstr = StringUtils.arrayToDelimitedString((Object[])pks, (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pkstr, CompareType.INCLUDE));
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        viewInfo.setSelector(selectors);
        DataBaseCollection collection = this.getDataBaseCollection(ctx, viewInfo);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < collection.size(); ++i) {
            DataBaseInfo info = collection.get(i);
            buffer.append(info.getLogInfo());
        }
        return buffer.toString();
    }
}

