/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.framework.ControlStrategy;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.HRDataBaseInfo;
import com.kingdee.eas.framework.app.AbstractHRDataBaseControllerBean;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Connection;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class HRDataBaseControllerBean
extends AbstractHRDataBaseControllerBean {
    private static final String CONTROLSTRATEGY = "controlStrategy";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.app.HRDataBaseControllerBean");
    private static final String BOTP_BIZ_REFERENCE = "com.kingdee.bos.metadata.bot.BOTPReference";
    private static final String SHARE_TYPE_NAME = "isUsedControlType";
    private String controlType = null;

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRDataBaseInfo dataBaseInfo = null;
        dataBaseInfo = (HRDataBaseInfo)model;
        this.setNumberFromCodingRule(ctx, dataBaseInfo, this.getCurrentOrgId(ctx, (IObjectValue)dataBaseInfo));
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getControlStrategy() == null) {
            dataBaseInfo.setControlStrategy(ControlStrategy.SHARE);
        }
        super._addnew(ctx, pk, (IObjectValue)dataBaseInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRDataBaseInfo dataBaseInfo = null;
        dataBaseInfo = (HRDataBaseInfo)model;
        this.setNumberFromCodingRule(ctx, dataBaseInfo, this.getCurrentOrgId(ctx));
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getControlStrategy() == null) {
            dataBaseInfo.setControlStrategy(ControlStrategy.SHARE);
        }
        return super._addnew(ctx, (IObjectValue)dataBaseInfo);
    }

    @Override
    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRDataBaseInfo dataBaseInfo = (HRDataBaseInfo)model;
        String name = dataBaseInfo.getName();
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    @Override
    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRDataBaseInfo dataBaseInfo = (HRDataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRDataBaseInfo dataBaseInfo = (HRDataBaseInfo)model;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    @Override
    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRDataBaseInfo dataBaseInfo = (HRDataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        HRDataBaseInfo info = (HRDataBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ctx, info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, HRDataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = this.getNextCompanyId(ctx);
        }
        if (orgId == null || orgId.trim().length() == 0) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId) && !iCodingRuleManager.isUserSelect((IObjectValue)caller, orgId)) {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            } else if (iCodingRuleManager.isAddView((IObjectValue)caller, orgId)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)caller, orgId)) {
                    iCodingRuleManager.checkModifiedNumber((IObjectValue)caller, orgId, caller.getNumber().toString());
                }
            } else {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            }
        }
    }

    protected String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    protected String getCurrentOrgId(Context ctx) {
        String OrgUnitId = null;
        CtrlUnitInfo company = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (company != null && company.getId() != null) {
            OrgUnitId = company.getId().toString();
        }
        return OrgUnitId;
    }

    protected final String getCurrentOrgIdForOrgType(Context ctx) {
        String OrgUnitId = null;
        CtrlUnitInfo company = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (company != null && company.getId() != null) {
            OrgUnitId = company.getId().toString();
        }
        return OrgUnitId;
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRDataBaseInfo dataBase = this.getHRDataBaseInfo(ctx, pk);
        this.recycleNumberFromCodingRule(ctx, dataBase, this.getCurrentOrgId(ctx, (IObjectValue)dataBase));
        super._delete(ctx, pk);
    }

    protected void recycleNumberFromCodingRule(Context ctx, HRDataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        if (caller.getClass().getPackage().getName().toLowerCase().indexOf("com.kingdee.eas.basedata.assistant") < 0 && caller.getClass().getPackage().getName().toLowerCase().indexOf("com.kingdee.eas.basedata.master") < 0) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId)) {
                iCodingRuleManager.recycleNumber((IObjectValue)caller, orgId, caller.getNumber());
            }
        } else {
            String root = this.getNextCompanyId(ctx);
            if (root != null && root.trim().length() > 0 && iCodingRuleManager.isExist((IObjectValue)caller, root) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, root)) {
                iCodingRuleManager.recycleNumber((IObjectValue)caller, root, caller.getNumber());
            }
        }
    }

    protected String _getPropertyAlias(Context ctx, HRDataBaseInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    @Override
    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        super._isReferenced(ctx, pk, cn);
        if (pk instanceof ObjectUuidPK) {
            try {
                IBizReference botpReference = this.getBOTPBizReference();
                if (botpReference != null && botpReference.checkReferenced(ctx, ((ObjectUuidPK)pk).getKeyValue()).isFound()) {
                    BizReference bizReference = new BizReference();
                    bizReference.setRefEntityAlias_L1("BOTP Rule");
                    bizReference.setRefEntityAlias_L2("BOTP Rule");
                    bizReference.setRefEntityAlias_L3("BOTP Rule");
                    throw new ObjectReferedException((Object)bizReference);
                }
            }
            catch (BizReferenceException exc) {
                // empty catch block
            }
        }
    }

    protected IBizReference getBOTPBizReference() {
        IBizReference result = null;
        try {
            result = (IBizReference)Class.forName(BOTP_BIZ_REFERENCE).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected String _getFullDisplayName(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String fullDisplayName = "";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        HRDataBaseInfo data = this.getHRDataBaseInfo(ctx, pk, selector);
        fullDisplayName = data.getName();
        return fullDisplayName;
    }

    protected final String getCurrentOrgId(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CoreBaseInfo info = (CoreBaseInfo)model;
        if (info == null || info.getId() == null) {
            return null;
        }
        OrgUnitInfo org = this.getCurrentOrgUnitForType(ctx, info);
        if (org == null) {
            return null;
        }
        String orgId = org.getId().toString();
        return orgId;
    }

    @Override
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRDataBaseInfo info = (HRDataBaseInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }

    @Override
    protected List _getPagingList(Context ctx, EntityViewInfo view, int start, int length) throws BOSException {
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (this.getControlType(ctx).equals("true")) {
            FilterInfo filter = this.getControlTypeFilter(ctx);
            this.mergeFilterToView(view, filter);
        }
        if (view.getSorter() == null || view.getSorter().size() == 0) {
            SorterItemCollection sortor = new SorterItemCollection();
            sortor.add(new SorterItemInfo("number"));
            view.setSorter(sortor);
        }
        return super._getPagingList(ctx, view, start, length);
    }

    @Override
    protected int _getCount(Context ctx, EntityViewInfo view) throws BOSException {
        if (this.getControlType(ctx).equals("true")) {
            FilterInfo filter = this.getControlTypeFilter(ctx);
            this.mergeFilterToView(view, filter);
        }
        return super._getCount(ctx, view);
    }

    private FilterInfo getControlTypeFilter(Context ctx) {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        EntityObjectInfo eoi = this.getBOSEntity(ctx);
        String tableName = eoi.getTable().getName();
        StringBuffer subStr = new StringBuffer();
        subStr.append("select bo.fid from ").append(tableName).append(" bo ").append(" inner join t_org_ctrlunit cu on cu.fid = bo.fcontrolunitid ").append(" where bo.FControlStrategy = 0 ").append("or bo.FControlStrategy = 1 and ").append("(CHARINDEX(CONCAT(cu.flongnumber, '!'), '").append(cu.getLongNumber()).append("') = 1 OR cu.fid = '").append(cu.getId()).append("')").append(" or bo.FControlStrategy = 2 and cu.fid='").append(cu.getId()).append("'").append("");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)subStr.toString(), CompareType.INNER));
        return filter;
    }

    private String getControlType(Context ctx) throws BOSException {
        if (this.controlType != null) {
            return this.controlType;
        }
        EntityObjectInfo eoi = this.getBOSEntity(ctx);
        this.controlType = "false";
        if (eoi.containsExtendedPropertyKey(SHARE_TYPE_NAME)) {
            this.controlType = eoi.getExtendedProperty(SHARE_TYPE_NAME);
        }
        return this.controlType;
    }

    protected EntityObjectInfo getBOSEntity(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(this.getBOSType());
        return entity;
    }
}

