/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config;

import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.UserCustomConfigData;
import com.kingdee.eas.framework.config.UserCustomConfigItem;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserCustomConfigSolution;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.util.Version;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class UserXMLHelper {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String CONFIGITEM_FILE = "/com/kingdee/eas/framework/config/configitems.xml";
    private static final String DATA_VERSION = "dataversion";
    private static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    private static ResourceBundleHelper resHelper = new ResourceBundleHelper(RESNAME);

    public static UserCustomConfigData loadData(String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        return UserXMLHelper.loadDataFromDocument(doc);
    }

    public static UserCustomConfigData loadData(InputStream in) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(in);
        return UserXMLHelper.loadDataFromDocument(doc);
    }

    public static UserCustomConfigData loadData(File xmlFile) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlFile);
        return UserXMLHelper.loadDataFromDocument(doc);
    }

    private static UserCustomConfigData loadDataFromDocument(Document doc) {
        Element rootElement = doc.getRootElement();
        List children = rootElement.getChildren();
        UserCustomConfigData data = new UserCustomConfigData();
        LinkedList<UserCustomConfigSolution> solutions = new LinkedList<UserCustomConfigSolution>();
        for (int i = 0; i < children.size(); ++i) {
            Element solutionEl = (Element)children.get(i);
            UserCustomConfigSolution solution = new UserCustomConfigSolution();
            String solutionName = solutionEl.getAttributeValue("name");
            solution.setName(solutionName);
            solution.setSelected(Boolean.getBoolean(solutionEl.getAttributeValue("selected")));
            solutions.add(solution);
            List itemDatas = solutionEl.getChildren();
            UserXMLHelper.loadItemData(itemDatas, solutionName, data);
        }
        data.setSolutions(solutions);
        data.setLoadByDefault(false);
        return data;
    }

    public static UserCustomConfigData loadDefaultData() {
        UserCustomConfigData data = new UserCustomConfigData();
        UserCustomConfigSolution solution = new UserCustomConfigSolution();
        solution.setName(resHelper.getString("Default"));
        solution.setSelected(true);
        LinkedList<UserCustomConfigSolution> solutions = new LinkedList<UserCustomConfigSolution>();
        solutions.add(solution);
        data.setSolutions(solutions);
        data.setLoadByDefault(true);
        return data;
    }

    private static void loadItemData(List itemDatas, String solutionName, UserCustomConfigData data) {
        for (int i = 0; i < itemDatas.size(); ++i) {
            Element itemEl = (Element)itemDatas.get(i);
            String itemName = itemEl.getAttributeValue("name");
            List datas = itemEl.getChildren();
            UserCustomConfigItemData itemData = new UserCustomConfigItemData();
            for (int j = 0; j < datas.size(); ++j) {
                Element dataEl = (Element)datas.get(j);
                itemData.getColumnData().put(dataEl.getAttributeValue("name"), dataEl.getAttributeValue("value"));
            }
            data.setItemData(solutionName, itemName, itemData);
        }
    }

    public static void saveData(UserPreferenceData data, Writer writer) throws IOException {
        UserXMLHelper.saveData(data, writer, DEFAULT_ENCODING);
    }

    public static void saveData(UserPreferenceData data, Writer writer, String encoding) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding(encoding);
        outputter.output(UserXMLHelper.prepareDocument(data), writer);
    }

    public static void saveData(UserCustomConfigData data, Writer writer) throws IOException {
        UserXMLHelper.saveData(data, writer, DEFAULT_ENCODING);
    }

    public static void saveData(UserCustomConfigData data, OutputStream out, String encoding) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding(encoding);
        outputter.output(UserXMLHelper.prepareDocument(data), out);
    }

    public static void saveData(UserCustomConfigData data, Writer writer, String encoding) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding(encoding);
        outputter.output(UserXMLHelper.prepareDocument(data), writer);
    }

    private static Document prepareDocument(UserPreferenceData data) {
        Element el = new Element("userconfig");
        el.setAttribute(DATA_VERSION, data.getVersion().getVerString());
        Document doc = new Document(el);
        Map tables = data.getTables();
        for (String tableName : tables.keySet()) {
            Element dataEl;
            UserCustomConfigItemData itemData = (UserCustomConfigItemData)tables.get(tableName);
            Element solutionEl = new Element("table");
            solutionEl.setAttribute("name", tableName);
            if (itemData == null) continue;
            Element itemDataEl = new Element("generic");
            for (String key : itemData.getGenericData().keySet()) {
                String value = (String)itemData.getGenericData().get(key);
                Element dataEl2 = new Element("data");
                dataEl2.setAttribute("name", key);
                dataEl2.setAttribute("value", value);
                itemDataEl.addContent(dataEl2);
            }
            solutionEl.addContent(itemDataEl);
            Element itemDataE2 = new Element("columndata");
            for (String key : itemData.getColumnData().keySet()) {
                String value = itemData.getColumnData().get(key).toString();
                dataEl = new Element("data");
                dataEl.setAttribute("name", key);
                dataEl.setAttribute("value", value);
                itemDataE2.addContent(dataEl);
            }
            solutionEl.addContent(itemDataE2);
            if (itemData.getTotalColumns() != null) {
                Element itemDataE3 = new Element("totalcolumns");
                for (String key : itemData.getTotalColumns()) {
                    dataEl = new Element("data");
                    dataEl.setAttribute("name", key);
                    itemDataE3.addContent(dataEl);
                }
                solutionEl.addContent(itemDataE3);
            }
            el.addContent(solutionEl);
        }
        return doc;
    }

    private static Document prepareDocument(UserCustomConfigData data) {
        Element el = new Element("solutions");
        Document doc = new Document(el);
        List solutions = data.getSolutions();
        for (int i = 0; i < solutions.size(); ++i) {
            UserCustomConfigSolution solution = (UserCustomConfigSolution)solutions.get(i);
            Element solutionEl = new Element("solution");
            solutionEl.setAttribute("name", solution.getName());
            solutionEl.setAttribute("selected", String.valueOf(solution.isSelected()));
            for (String itemName : data.getAllItems().keySet()) {
                UserCustomConfigItemData itemData = data.getItemData(solution.getName(), itemName);
                if (itemData == null) continue;
                Element itemDataEl = new Element("configitemdata");
                itemDataEl.setAttribute("name", itemName);
                for (String key : itemData.getColumnData().keySet()) {
                    String value = itemData.getColumnData().get(key).toString();
                    Element dataEl = new Element("data");
                    dataEl.setAttribute("name", key);
                    dataEl.setAttribute("value", value);
                    itemDataEl.addContent(dataEl);
                }
                solutionEl.addContent(itemDataEl);
            }
            el.addContent(solutionEl);
        }
        return doc;
    }

    public static UserCustomConfigItem getConfigItem(String itemName, String keyName, Component component) throws JDOMException, IOException {
        return UserXMLHelper.getConfigItem(UserXMLHelper.class.getResourceAsStream(CONFIGITEM_FILE), itemName, keyName, component);
    }

    public static UserCustomConfigItem getConfigItem(InputStream stream, String itemName, String keyName, Component component) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(stream);
        Element rootElement = doc.getRootElement();
        Element tableElement = null;
        List children = rootElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element tmpEl = (Element)children.get(i);
            if (!tmpEl.getAttributeValue("name").equals(keyName)) continue;
            tableElement = tmpEl;
            break;
        }
        if (tableElement == null) {
            return null;
        }
        UserCustomConfigItem item = new UserCustomConfigItem();
        item.setName(itemName);
        item.setDesc(component.getName());
        UserXMLHelper.addItem(item, tableElement, component);
        return item;
    }

    private static void addItem(UserCustomConfigItem item, Element tableElement, Component component) {
        boolean addItemFailed = false;
        item.setComponent(component);
        if (tableElement.getChild("ui") != null && !tableElement.getChild("ui").getAttribute("class").getValue().equals("")) {
            try {
                item.setItemUI((CoreUI)Class.forName(tableElement.getChild("ui").getAttribute("class").getValue()).newInstance());
            }
            catch (Exception e) {
                addItemFailed = true;
            }
        }
        if (addItemFailed) {
            return;
        }
        List subItems = tableElement.getChildren("configitem");
        if (subItems != null && subItems.size() > 0) {
            for (int i = 0; i < subItems.size(); ++i) {
                UserCustomConfigItem subItem = new UserCustomConfigItem();
                Element tmpEl = (Element)subItems.get(i);
                subItem.setName(item.getName() + "." + tmpEl.getAttributeValue("name"));
                subItem.setDesc(tmpEl.getAttributeValue("desc"));
                subItem.setParent(item);
                item.getSubItems().add(subItem);
                UserXMLHelper.addItem(subItem, tmpEl, component);
            }
        }
    }

    public static UserPreferenceData loadPreferenceData(String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element rootElement = doc.getRootElement();
        List children = rootElement.getChildren();
        UserPreferenceData data = new UserPreferenceData();
        data.setVersion(Version.parseVersion(rootElement.getAttributeValue(DATA_VERSION)));
        for (int i = 0; i < children.size(); ++i) {
            Element tableEl = (Element)children.get(i);
            String tableName = tableEl.getAttributeValue("name");
            data.getTables().put(tableName, UserXMLHelper.loadTableItemData(tableEl));
        }
        return data;
    }

    private static UserCustomConfigItemData loadTableItemData(Element tableEl) {
        Element dataEl;
        int i;
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        List itemDatas = tableEl.getChild("generic").getChildren();
        for (i = 0; i < itemDatas.size(); ++i) {
            dataEl = (Element)itemDatas.get(i);
            itemData.getGenericData().put(dataEl.getAttributeValue("name"), dataEl.getAttributeValue("value"));
        }
        itemDatas = tableEl.getChild("columndata").getChildren();
        for (i = 0; i < itemDatas.size(); ++i) {
            dataEl = (Element)itemDatas.get(i);
            itemData.getColumnData().put(dataEl.getAttributeValue("name"), dataEl.getAttributeValue("value"));
        }
        if (tableEl.getChild("totalcolumns") != null) {
            itemDatas = tableEl.getChild("totalcolumns").getChildren();
            ArrayList<String> list = new ArrayList<String>();
            for (int i2 = 0; i2 < itemDatas.size(); ++i2) {
                Element dataEl2 = (Element)itemDatas.get(i2);
                list.add(dataEl2.getAttributeValue("name"));
            }
            itemData.setTotalColumns(list);
        }
        return itemData;
    }
}

