/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.UILifeCycleHander;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.expression.IBizConfigureInfo;
import com.kingdee.eas.framework.expression.RegularSizePosition;
import com.kingdee.eas.framework.expression.UILayoutExecutorHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class UILayoutExecutor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.expression.UILayoutExecutor");
    private UIObjectInfo cfgUI;
    private CoreUI targetUI;
    DataBinder dataBinder;
    IBizConfigureInfo configure;
    BizUnitInfo bizUnit;
    EntityObjectInfo entity;
    UILifeCycleHander handler;
    private Map localCtx;
    private boolean isExecuting = false;
    public static final String CONTAINER = "container";

    public UILayoutExecutor(CoreUI targetUI, Context ctx, Map localCtx, UIObjectInfo cfgUI, DataBinder dataBinder, IBizConfigureInfo configure, UILifeCycleHander handler) {
        this.cfgUI = cfgUI;
        this.targetUI = targetUI;
        this.localCtx = localCtx;
        this.dataBinder = dataBinder;
        this.configure = configure;
        this.handler = handler;
        try {
            String entityPK;
            this.bizUnit = UILayoutExecutorHelper.loadBizUnit(new MetaDataPK(configure.getBizUnitPK()));
            if (this.bizUnit != null && !StringUtils.isEmpty((String)(entityPK = this.bizUnit.getString("entityPK")))) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                this.entity = loader.getEntity((IMetaDataPK)new MetaDataPK(entityPK));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void execute() throws Exception {
        if (!this.isExecuting && this.cfgUI != null) {
            ComponentCollection col = this.cfgUI.getComponents();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo cInfo = col.get(i);
                if (cInfo.getConstraint() == null || !(cInfo.getConstraint() instanceof Rectangle)) continue;
                Rectangle rect = (Rectangle)cInfo.getConstraint();
                if (this.localCtx.containsKey(cInfo.getName())) {
                    String containerName;
                    KDLabelContainer lblContainer;
                    JComponent component = (JComponent)this.localCtx.get(cInfo.getName());
                    if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType()) && component instanceof KDTable) {
                        UILayoutExecutorHelper.initCellEditor(this.entity, cInfo, (KDTable)component, this.dataBinder);
                    }
                    if ((lblContainer = this.getLabelContainer(component)) != null) {
                        component = lblContainer;
                        this.reSetLabelContainerProperty(lblContainer, cInfo);
                    }
                    Container container = !StringUtils.isEmpty((String)(containerName = cInfo.getExtendedProperty(CONTAINER))) && this.localCtx.containsKey(containerName) ? (Container)this.localCtx.get(containerName) : null;
                    this.layoutComponent(container, component, rect);
                    continue;
                }
                if (!cInfo.isConfigured()) continue;
                this.createControl(cInfo, rect);
            }
            this.reOrderEntryColumn((JComponent)this.targetUI);
            if (col.size() > 0 && this.needResetLayout()) {
                this.resetLayout((JComponent)this.targetUI);
                this.targetUI.revalidate();
            }
        }
        this.isExecuting = true;
    }

    private boolean needResetLayout() {
        String autolayout;
        return this.cfgUI == null || !"false".equals(autolayout = this.cfgUI.getExtendedProperty("_Auto_Layout"));
    }

    private void resetLayout(JComponent component) {
        if (component == null) {
            return;
        }
        RegularSizePosition rsp = new RegularSizePosition();
        rsp.regular(component);
    }

    private void clearKDLayout(JComponent component) {
        if (component == null) {
            return;
        }
        for (Component child : component.getComponents()) {
            JComponent jcom;
            Object constraint;
            if (child instanceof JComponent && (constraint = (jcom = (JComponent)child).getClientProperty("KDLayoutConstraints")) instanceof KDLayout.Constraints) {
                ((KDLayout.Constraints)constraint).anchor = 0;
            }
            if (!(child instanceof JComponent)) continue;
            this.clearKDLayout((JComponent)child);
        }
    }

    private void reOrderEntryColumn(JComponent component) {
        if (component == null) {
            return;
        }
        for (Component child : component.getComponents()) {
            if (child instanceof KDTable) {
                KDTable table = (KDTable)child;
                UILayoutExecutorHelper.reOrderTableColumn(table, this.cfgUI);
                continue;
            }
            if (!(child instanceof JComponent)) continue;
            this.reOrderEntryColumn((JComponent)child);
        }
    }

    private KDLabelContainer getLabelContainer(JComponent component) {
        if (component != null && component.getParent() != null) {
            if (component.getParent() instanceof KDLabelContainer) {
                return (KDLabelContainer)component.getParent();
            }
            if (component.getParent().getParent() != null && component.getParent().getParent() instanceof KDLabelContainer) {
                return (KDLabelContainer)component.getParent().getParent();
            }
        }
        return null;
    }

    private void reSetLabelContainerProperty(KDLabelContainer lblContainer, ComponentInfo cInfo) {
        if (lblContainer != null && cInfo != null) {
            String ext = cInfo.getExtendedProperty("boundLabelLength");
            if (!StringUtils.isEmpty((String)ext)) {
                try {
                    int len = Integer.parseInt(ext);
                    lblContainer.setBoundLabelLength(len);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((String)(ext = cInfo.getExtendedProperty("boundLabelUnderline"))) && "false".equalsIgnoreCase(ext)) {
                lblContainer.setBoundLabelUnderline(false);
            }
        }
    }

    private boolean isKDLayout(Container component) {
        if (component == null) {
            return false;
        }
        return component.getLayout() != null && component.getLayout() instanceof KDLayout;
    }

    private void layoutComponent(Container container, JComponent component, Rectangle rect) {
        if (container == null || container.equals(component.getParent())) {
            KDTable table;
            if (component instanceof KDTable && (table = (KDTable)component).getParent() != null && table.getParent().getParent() != null) {
                if (table.getParent().getParent() instanceof DetailPanel) {
                    component = (JComponent)table.getParent().getParent();
                } else if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(table.getParent().getParent().getClass().getName())) {
                    return;
                }
            }
            if (this.isKDLayout(component.getParent())) {
                Object constraint = component.getClientProperty("KDLayoutConstraints");
                if (constraint != null && constraint instanceof KDLayout.Constraints) {
                    ((KDLayout.Constraints)constraint).originalBounds = rect;
                }
                component.setBounds(rect);
            } else {
                component.setBounds(rect);
            }
        } else if (this.isKDLayout(container)) {
            KDLayout.Constraints constraint = new KDLayout.Constraints(rect.x, rect.y, rect.width, rect.height, 0);
            constraint.originalBounds = rect;
            container.add((Component)component, constraint);
        } else {
            component.setBounds(rect);
            container.add((Component)component, rect);
        }
    }

    private Component createControl(ComponentInfo cInfo, Rectangle rect) {
        if (cInfo == null) {
            return null;
        }
        ComponentInfo old = cInfo;
        String classType = cInfo.getClassType();
        Component control = null;
        String containerName = cInfo.getExtendedProperty(CONTAINER);
        try {
            PropertyInfo prop;
            control = (Component)Class.forName(classType).newInstance();
            control.setName(cInfo.getName());
            UILayoutExecutorHelper.initComponent(this.entity, cInfo, control);
            this.localCtx.put(control.getName(), control);
            this.registerBindings(cInfo, control);
            if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(cInfo.getClassType()) && control instanceof KDCheckBox && (prop = cInfo.getProperties().get("text")) != null) {
                ((KDCheckBox)control).setText(prop.getValue());
            }
            if (cInfo.getParent() != null) {
                if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                    cInfo = cInfo.getParent();
                    KDScrollPane sp = new KDScrollPane();
                    sp.getViewport().add(control, null);
                    control = sp;
                    control.setName(cInfo.getName());
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType())) {
                    cInfo = cInfo.getParent();
                    KDLabelContainer lblContainer = new KDLabelContainer();
                    lblContainer.setBoundLabelLength(UILayoutExecutorHelper.getLabelLength(cInfo));
                    lblContainer.setBoundLabelUnderline(UILayoutExecutorHelper.getLabelUnderLine(cInfo));
                    lblContainer.setBoundLabelAlignment(7);
                    lblContainer.setBoundEditor((JComponent)control);
                    control = lblContainer;
                    control.setName(cInfo.getName());
                    this.localCtx.put(control.getName(), control);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"create components fail in UILayoutExecutor");
            return null;
        }
        if (control != null && !StringUtils.isEmpty((String)containerName) && this.localCtx.containsKey(containerName)) {
            Container container = (Container)this.localCtx.get(containerName);
            this.setComponentProperties(control, old);
            if (this.isKDLayout(container)) {
                KDLayout.Constraints cons = new KDLayout.Constraints(0, rect);
                ((JComponent)control).putClientProperty("KDLayoutConstraints", cons);
            }
            control.setBounds(rect);
            container.add(control);
        }
        return control;
    }

    private void setComponentProperties(Component control, ComponentInfo cInfo) {
        if (cInfo.getParent() != null) {
            PropertyInfo property;
            if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                cInfo = cInfo.getParent();
            }
            if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType()) && (property = cInfo.getParent().getPropertyByName("boundLabelText")) != null) {
                this.setComponentTextProp(control, property.getValue());
            }
        } else {
            PropertyInfo property = cInfo.getPropertyByName("text");
            if (property != null) {
                this.setComponentTextProp(control, property.getValue());
            }
        }
    }

    private void setComponentTextProp(Component control, String text) {
        if (control instanceof JToggleButton) {
            ((JToggleButton)control).setText(text);
        } else if (control instanceof KDLabelContainer) {
            ((KDLabelContainer)control).setBoundLabelText(text);
        } else {
            logger.info((Object)"the component is not JToggleButton or KDLabelContainer. Can not set the text..");
        }
    }

    private void registerBindings(ComponentInfo cInfo, Component comp) {
        int nn = cInfo.getPropertyBindings().size();
        for (int i = 0; i < nn; ++i) {
            PropertyBindingInfo propbInfo = cInfo.getPropertyBindings().get(i);
            if (cInfo.isHerited() && propbInfo.isHerited() && !propbInfo.isOverride()) {
                return;
            }
            String tempClassName = propbInfo.getFieldType();
            Class clazz = UILayoutExecutorHelper.getClassName(tempClassName);
            if (clazz == null) continue;
            try {
                this.dataBinder.registerBinding(propbInfo.getBingdingField(), clazz, comp, propbInfo.getPropertyName());
                logger.info((Object)("head bind:dataBinder.registerBinding(" + propbInfo.getBingdingField() + "," + clazz + "," + comp.getName() + "," + propbInfo.getPropertyName() + ");"));
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"bind fail", (Throwable)ex);
            }
        }
    }

    public void remove(UIObjectInfo cfgUI, Map localCtx) throws Exception {
        if (cfgUI != null) {
            ComponentCollection col = cfgUI.getComponents();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                JComponent component;
                ComponentInfo cInfo = col.get(i);
                if (cInfo.isConfigured()) {
                    String[] cfg = this.getCfgContainer(cInfo);
                    if (cfg == null || cfg.length != 2) continue;
                    component = (JComponent)localCtx.get(cfg[0]);
                    JComponent container = (JComponent)localCtx.get(cfg[1]);
                    container.remove(component);
                    localCtx.remove(cfg[0]);
                    localCtx.remove(cInfo.getName());
                    logger.info((Object)("delete component:" + component.getName()));
                    this.unRegisterBindings(cInfo, component);
                    continue;
                }
                if (!"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType()) || !localCtx.containsKey(cInfo.getName()) || !((component = (JComponent)localCtx.get(cInfo.getName())) instanceof KDTable)) continue;
                UILayoutExecutorHelper.removeCfgCell(this.entity, cInfo, (KDTable)component, this.dataBinder);
            }
        }
    }

    private String[] getCfgContainer(ComponentInfo cInfo) {
        if (cInfo != null) {
            String[] ret = new String[2];
            if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(cInfo.getClassType())) {
                ret[0] = cInfo.getName();
                ret[1] = cInfo.getParent().getName();
                return ret;
            }
            if (cInfo.getParent() != null) {
                if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                    cInfo = cInfo.getParent();
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType())) {
                    cInfo = cInfo.getParent();
                }
                ret[0] = cInfo.getName();
                ret[1] = cInfo.getParent().getName();
                return ret;
            }
        }
        return null;
    }

    private void unRegisterBindings(ComponentInfo cInfo, Component comp) {
        int nn = cInfo.getPropertyBindings().size();
        for (int i = 0; i < nn; ++i) {
            PropertyBindingInfo propbInfo = cInfo.getPropertyBindings().get(i);
            if (cInfo.isHerited() && propbInfo.isHerited() && !propbInfo.isOverride()) {
                return;
            }
            String tempClassName = propbInfo.getFieldType();
            Class clazz = UILayoutExecutorHelper.getClassName(tempClassName);
            if (clazz == null) continue;
            try {
                this.dataBinder.unRegisterBinding(propbInfo.getBingdingField(), clazz, comp, propbInfo.getPropertyName());
                logger.info((Object)("head unRegisterBind:dataBinder.unRegisterBinding(" + propbInfo.getBingdingField() + "," + clazz + "," + comp.getName() + "," + propbInfo.getPropertyName() + ");"));
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"unbind fail", (Throwable)ex);
            }
        }
    }

    public void destroy() {
    }
}

