/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.FastQueryOptionUI;
import com.kingdee.eas.framework.query.IFastFilter;
import com.kingdee.eas.framework.query.IFastQuery;
import com.kingdee.eas.framework.query.IQuickSearchQuery;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.RecentQuickSearchItemsMananger;
import com.kingdee.eas.framework.query.component.AbstractListPopupItem;
import com.kingdee.eas.framework.query.component.AutoCompletionTextField;
import com.kingdee.eas.framework.query.component.CompositeListPopupItem;
import com.kingdee.eas.framework.query.component.DateRangePopupManager;
import com.kingdee.eas.framework.query.component.FixedPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.KDRoundRectBorder;
import com.kingdee.eas.framework.query.component.QuickFilterAutoCompletionPopup;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class FastQueryPanel
extends KDPanel
implements IFastQuery {
    private static Logger logger = Logger.getLogger(FastQueryPanel.class);
    final IQuickSearchQuery _parentUI;
    AutoCompletionTextField _txtFastInput;
    IFastFilter fastFilter;
    private QuickFilteringSupportItems supportItems;
    FastQueryOptionUI fastQueryOptionUI;
    static final int H = 40;
    private static final int H_COMPONENT = 30;
    static final Color COLOR_LINE = new Color(191, 200, 209);
    private RecentQuickSearchItemsMananger rqsi;
    private QuickFilterAutoCompletionPopup popup;
    private String uiName;

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(COLOR_LINE);
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public QuerySolutionInfo getCurrentSolution() {
        return this.fastFilter.getCurrentSelectedSolution();
    }

    public void setFastFilter(IFastFilter fastFilter) {
        this.fastFilter = fastFilter;
    }

    @Override
    public IFastFilter getFastFilter() {
        return this.fastFilter;
    }

    public FastQueryPanel(IQuickSearchQuery parentUI, Rectangle rec, int right, QuickFilteringSupportItems supportItems) {
        this._parentUI = parentUI;
        this.supportItems = supportItems;
        try {
            Object[] configs = this.initCommponet(rec, right);
            this.initQuickSearchSolution(supportItems, configs);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void initQuickSearchSolution(QuickFilteringSupportItems supportItems, Object[] configs) {
        this.rqsi = new RecentQuickSearchItemsMananger(this.getCurrentUIName(), (MetaDataPK)this._parentUI.getMainQueryPK(), this.popup);
        if (configs[0] != null && ((FilterItemCollection)configs[0]).size() > 0) {
            this.rqsi.loadRecentQuickSearchItems();
        }
        this.fastQueryOptionUI.initPopupValue();
        this._txtFastInput.initDateRangePopup(supportItems, this);
    }

    @Override
    public String getCurrentUIName() {
        if (this.uiName != null) {
            return this.uiName;
        }
        this.uiName = this._parentUI.getMetaDataPK().getFullName();
        int index = this.uiName.indexOf("$$");
        if (index > 0) {
            this.uiName = this.uiName.substring(0, index);
        }
        return this.uiName;
    }

    public QuerySolutionInfo getCurrentSelectedSolution() {
        return this.fastFilter.getCurrentSelectedSolution();
    }

    private Object[] initCommponet(Rectangle rec, int right) throws Exception {
        this.setBounds(rec);
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", rec);
        this.fastQueryOptionUI = new FastQueryOptionUI(this._parentUI, this, this.supportItems);
        int y = 5;
        int w_FastQueryOptionUI = (int)((double)right * 0.305);
        int w_FastInput = (int)((double)right * 0.43);
        this.fastQueryOptionUI.setBounds(10, y, w_FastQueryOptionUI, 30);
        this.add((Component)((Object)this.fastQueryOptionUI), new KDLayout.Constraints(10, y, w_FastQueryOptionUI, 30, 263));
        this.fastQueryOptionUI.onLoad();
        this.fastFilter = this.fastQueryOptionUI.fastFilter;
        Object[] configs = this.supportItems.getQuickSearchConfigs();
        this._txtFastInput = new AutoCompletionTextField();
        this.popup = new QuickFilterAutoCompletionPopup(this, this._txtFastInput, this.fastFilter.getQueryPK(), configs);
        this._txtFastInput.setPopup(this.popup);
        this._txtFastInput.setBorder(new KDRoundRectBorder());
        this._txtFastInput.setBounds(right - w_FastInput, y, w_FastInput, 30);
        this.add((Component)((Object)this._txtFastInput), new KDLayout.Constraints(right - w_FastInput, y, w_FastInput, 30, 137));
        this.add((Component)((Object)this._txtFastInput));
        return configs;
    }

    private void clearFilters() {
        this._txtFastInput.clearFilters();
    }

    @Override
    public void solutionChanged(QuerySolutionInfo solutionInfo, boolean refreshList) {
        this.clearFilters();
        this.fastQueryOptionUI.solutionChanged(solutionInfo, refreshList);
    }

    @Override
    public void executeQuery(FilterInfo filter, boolean excludeFastFilter, boolean isOnRefresh) {
        Object fastFilterInfo = null;
        FilterInfo resultFilter = (FilterInfo)filter.clone();
        if (!excludeFastFilter && fastFilterInfo != null && fastFilterInfo.getFilterItems() != null) {
            for (int i = 0; i < fastFilterInfo.getFilterItems().size(); ++i) {
                resultFilter.getFilterItems().add(fastFilterInfo.getFilterItems().get(i));
            }
        }
        if (this.executeQueryWithOrgFilter(resultFilter, isOnRefresh)) {
            return;
        }
        if (this.supportItems.getSystemSolutionItem().equals(this.fastFilter.getCurrentSelectedSolutionItem())) {
            this.executeQueryAsSystemSolution(isOnRefresh, resultFilter);
        } else if (fastFilterInfo != null || !this.fastFilter.isBlankSolution()) {
            this._parentUI.doQuery(this.getCurrentSelectedSolution(), resultFilter, null, isOnRefresh);
        }
    }

    private boolean executeQueryWithOrgFilter(FilterInfo resultFilter, boolean isOnRefresh) {
        FilterItemInfo orgFilterItemInfo = null;
        QuerySolutionInfo curSolution = this.getCurrentSelectedSolution();
        if (curSolution != null && curSolution.isIsUserDefaultSolu() || isOnRefresh && this.supportItems.getSystemSolutionItem().equals(this.fastFilter.getCurrentSelectedSolutionItem())) {
            return false;
        }
        if (this.fastFilter.isBlankSolution()) {
            orgFilterItemInfo = this.fastQueryOptionUI.getOrgFilterItemInfo();
        }
        if (orgFilterItemInfo != null) {
            FilterInfo orgFilter = new FilterInfo();
            orgFilter.getFilterItems().add(orgFilterItemInfo);
            try {
                resultFilter.mergeFilter(orgFilter, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this._parentUI.doQuery(this.getCurrentSelectedSolution(), resultFilter, this.fastQueryOptionUI.getMainOrgs(), isOnRefresh);
        return true;
    }

    private void executeQueryAsSystemSolution(boolean isOnRefresh, FilterInfo resultFilter) {
        if (!this._parentUI.isSameSolutionExecuted(this.getCurrentSelectedSolution())) {
            FilterInfo defFilter = this.supportItems.getSystemSolutionItem().getDefaultFilter().getFilter();
            for (int i = 0; defFilter != null && i < defFilter.getFilterItems().size(); ++i) {
                resultFilter.getFilterItems().add(defFilter.getFilterItems().get(i));
            }
        }
        this._parentUI.doQuery(this.getCurrentSelectedSolution(), resultFilter, this.supportItems.getSystemSolutionItem().getMainOrgs(), isOnRefresh);
    }

    @Override
    public boolean refresh() {
        if (this._parentUI != null && this._parentUI instanceof ListUI && !((ListUI)this._parentUI).isIsDefalutShowCountAndSumRow()) {
            ((ListUI)this._parentUI).setIsCountAndSumRow(false);
        }
        if (this.fastFilter.isBlankSolution()) {
            IListPopupItem selectedItem = this.fastQueryOptionUI.getQuickFilterPopupMenuManager().getSelectedPopupItem();
            if (selectedItem != null) {
                selectedItem.execute(true);
                return true;
            }
            return false;
        }
        this.executeQuery(new FilterInfo(), false, true);
        return true;
    }

    @Override
    public void switchToOrg() {
        this.clearFilters();
    }

    @Override
    public RecentQuickSearchItemsMananger getRecentQuickSearchItemsMananger() {
        return this.rqsi;
    }

    @Override
    public void executeItem(IListPopupItem item, boolean isOnRefresh) {
        if (item == null && !this.supportItems.isExecuteQueryWithoutFilters()) {
            return;
        }
        this.fastFilter.executeItem(item, isOnRefresh);
        if (!isOnRefresh && item instanceof CompositeListPopupItem) {
            this.rqsi.addRecentQuickSearchItem(item);
        } else if (item instanceof FixedPopupItem) {
            this.clearFilters();
        }
        this.fastQueryOptionUI.executeItem(item, isOnRefresh);
        this.executePopupItem((AbstractListPopupItem)item);
    }

    private void executePopupItem(AbstractListPopupItem item) {
        FilterInfo resultFilter = item != null && item.getFilterInfo() != null ? (FilterInfo)item.getFilterInfo().clone() : new FilterInfo();
        if (!(item instanceof FixedPopupItem) && this._txtFastInput.getSelectedDateRangeItem() != null) {
            try {
                resultFilter.mergeFilter(((AbstractListPopupItem)this._txtFastInput.getSelectedDateRangeItem()).getFilterInfo(), "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this.executeQueryWithOrgFilter(resultFilter, false);
    }

    @Override
    public void executeRecentOnWeekAtFirst() {
        if (this.fastQueryOptionUI.getQuickFilterPopupMenuManager().ITEM_RECENTONEWEEK != null) {
            this.executeItem(this.fastQueryOptionUI.getQuickFilterPopupMenuManager().ITEM_RECENTONEWEEK, false);
        } else if (!this.supportItems.isMustQueryAtFirst()) {
            this._parentUI.getMainTable().removeRows(false);
        }
    }

    @Override
    public DateRangePopupManager getDateRangePopupManager() {
        return this._txtFastInput.getDateRangePopupManager();
    }
}

