/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.query.app.AbstractQueryServiceFacadeControllerBean;
import com.kingdee.util.StringUtils;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class QueryServiceFacadeControllerBean
extends AbstractQueryServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.query.app.QueryServiceFacadeControllerBean");

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, IMetaDataPK queryPK) throws BOSException, EASBizException {
        String permItem = this.getPermissionItem(ctx, queryPK);
        OrgUnitCollection collection = this.getAuthOrgByPermItem(ctx, orgType, permItem);
        OrgUnitCollection bizOrgs = this.getOrgUnitInfosByType(ctx, collection, orgType);
        return bizOrgs;
    }

    private String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    private OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    private OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType) throws EASBizException, BOSException {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return results;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin) && !orgType.equals((Object)OrgType.ControlUnit)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.setSelector(this.getOrgInfoSelector(orgType));
        return NewOrgViewHelper.getOrgUnitCollection((Context)ctx, (OrgType)orgType, (EntityViewInfo)view);
    }

    private SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }
}

