/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.component.AutoCompletionTextField;
import com.kingdee.eas.framework.query.component.FixedPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.component.IPopupInvoker;
import com.kingdee.eas.framework.query.component.ListPopup;
import com.kingdee.eas.framework.query.component.QuickFilterAutoCompletionPopup;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.framework.util.StringUtility;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.ListModel;

public class DateRangePopupManager
implements IPopupInvoker {
    private ListPopup dateRangePopup;
    private IListPopupItem selectedDateRangeItem;
    private AutoCompletionTextField parent;
    private KDLabel dateRangeBox;
    private String bizDateField;
    private IListPopupItemExecute executor;

    public DateRangePopupManager(AutoCompletionTextField parent, KDLabel dateRangeBox, String bizDateField, IListPopupItemExecute executor) {
        this.parent = parent;
        this.dateRangeBox = dateRangeBox;
        this.bizDateField = bizDateField;
        this.executor = executor;
    }

    IListPopupItem getSelectedDateRangeItem() {
        return this.selectedDateRangeItem;
    }

    void initDateRangePopupModel(QuickFilteringSupportItems supportItems) {
        int length = 0;
        IListPopupItemExecute dateRangeItemExecutor = this.createDateRangeItemExecutor();
        LinkedList<IListPopupItem> model = supportItems.getDateRangePopupModel();
        if (model.size() <= 0) {
            return;
        }
        IListPopupItem defaultItem = model.getFirst();
        for (IListPopupItem aitem : model) {
            FixedPopupItem item = (FixedPopupItem)aitem;
            item.setExecutor(dateRangeItemExecutor);
            if (item.isDefault()) {
                defaultItem = item;
            }
            length = this.getMaxTextLength(item.getDisplayValue(), length);
        }
        this.dateRangePopup = new ListPopup(this);
        this.dateRangePopup.setList(model);
        this.updateSelectedDateRangeItem(defaultItem);
        this.parent.setW_DATEBOX(length * 7 + 20);
    }

    private int getMaxTextLength(String text, int length) {
        int l = StringUtility.length(text);
        return l > length ? l : length;
    }

    private IListPopupItemExecute createDateRangeItemExecutor() {
        IListPopupItemExecute dateRangeExecutor = new IListPopupItemExecute(){

            @Override
            public void executeItem(IListPopupItem item, boolean isOnRefresh) {
                DateRangePopupManager.this.updateSelectedDateRangeItem(item);
                QuickFilterAutoCompletionPopup popup = (QuickFilterAutoCompletionPopup)DateRangePopupManager.this.parent.getPopup();
                IListPopupItem citem = popup.createCompositeListPopupItem();
                if (citem == null) {
                    return;
                }
                DateRangePopupManager.this.executor.executeItem(citem, false);
            }
        };
        return dateRangeExecutor;
    }

    void invokeDateRangeMouseListener(MouseEvent e) {
        this.dateRangePopup.getMouseListener().mousePressed(e);
    }

    private void updateSelectedDateRangeItem(IListPopupItem item) {
        this.selectedDateRangeItem = item;
        this.dateRangeBox.setText("  " + item.getDisplayValue());
        String tip = QuickFilterResources.getMessage("SEARCHIN", new String[]{item.getDisplayValue()});
        if (this.parent.searchInfoTips != null) {
            this.parent.setInfoLabelText("<HTML><font color=#C0C0C0 size=3>" + tip + ", " + this.parent.searchInfoTips + "</font></HTML>");
        }
        this.updateSelectedIndex(item);
    }

    private void updateSelectedIndex(IListPopupItem item) {
        if (this.dateRangePopup == null) {
            return;
        }
        ListModel listModel = this.dateRangePopup.getList().getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!item.equals(listModel.getElementAt(i))) continue;
            this.dateRangePopup.setSelectedIndex(i);
            this.parent.repaint();
        }
    }

    public final void updateSelectedDateRangeItem(int index) {
        if (this.dateRangePopup == null) {
            return;
        }
        ListModel listModel = this.dateRangePopup.getList().getModel();
        if (listModel.getSize() <= index) {
            return;
        }
        this.updateSelectedDateRangeItem((IListPopupItem)listModel.getElementAt(index));
    }

    @Override
    public JComponent getOwner() {
        return this.parent;
    }

    @Override
    public Point getPopupLocation() {
        return new Point(this.parent.getWidth() - this.parent.getW_DATEBOX(), this.parent.getHeight() - 1);
    }

    @Override
    public Dimension getPopupSize() {
        return new Dimension(this.parent.getW_DATEBOX(), 25 * this.dateRangePopup.getList().getModel().getSize());
    }

    @Override
    public Rectangle getFocusedBounds() {
        Rectangle recParent = this.parent.getBounds();
        Rectangle r = new Rectangle(this.parent.getDateRangeBoxX(), recParent.y, this.parent.getW_DATEBOX(), recParent.height);
        return r;
    }
}

