/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.ctrl.kdf.table.cellformatter.ICellFormatter;
import com.kingdee.eas.framework.report.util.ICellFormatFunction;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RptCellFormatter
implements ICellFormatter {
    public static final String FORMAT_ZERO2EMPTY = "@=0?:$_";
    public static final String FORMAT_NULL2EMPTY = "@=?:$_";
    public static final String FORMAT_FUNC_PREFIX = "@FUNC";
    private Map cache = new HashMap();
    private Map funcMap = new HashMap();

    public static String getNumberFormat(int precision, boolean emptyWithZero) {
        return new StringBuffer("@f(").append(RptCellFormatter.class.getName()).append("$RptNumberFormat#").append(emptyWithZero ? "formatEmptyWithZero" : "format").append(",$_,").append(precision).append(')').toString();
    }

    public static String getDateFormat(String pattern) {
        return new StringBuffer("@f(").append(RptCellFormatter.class.getName()).append("$RptDateFormat(").append(pattern).append(")#format,$_)").toString();
    }

    public static String getTrimZeroFormat() {
        return new StringBuffer("@f(").append(RptCellFormatter.class.getName()).append("$RptNumberFormat#trimRedundantZero,$_)").toString();
    }

    public static String buildFormatFunctionNameKey(String name) {
        return FORMAT_FUNC_PREFIX + name;
    }

    public void addFormatFunction(String name, ICellFormatFunction func) {
        this.funcMap.put(name, func);
    }

    public String format(String format, Object data) {
        if (format.startsWith(FORMAT_FUNC_PREFIX)) {
            ICellFormatFunction func = (ICellFormatFunction)this.funcMap.get(format.substring(FORMAT_FUNC_PREFIX.length()));
            return func.format(data);
        }
        try {
            return this.getFormatStmt(format).format(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RptCellFormatter.toObjectString(data);
        }
    }

    private FormatStmt getFormatStmt(String format) {
        String s = format.trim();
        FormatStmt f = (FormatStmt)this.cache.get(s);
        if (f == null) {
            f = s.startsWith("@f(") ? new FunctionFormatStmt(s) : new TernaryFormatStmt(s);
            this.cache.put(s, f);
        }
        return f;
    }

    private static String toObjectString(Object value) {
        return value == null ? "" : String.valueOf(value);
    }

    public static void main(String[] args) throws IllegalFormatExpress {
        RptCellFormatter rcf = new RptCellFormatter();
        System.out.println(rcf.format("@=?NULL\u503c:\u539f\u59cb\u503c$_", "super start"));
        System.out.println(rcf.format("@=?NULL\u503c:\u539f\u59cb\u503c$_", ""));
        System.out.println(rcf.format("@=?\u7a7a\u503c:\u539f\u59cb\u503c$_", null));
        System.out.println(rcf.format(RptCellFormatter.getNumberFormat(3, true), "-108,156.20385"));
        System.out.println(rcf.format(RptCellFormatter.getNumberFormat(3, true), "0.3324234"));
    }

    public static final class RptDateFormat {
        private SimpleDateFormat osdf = null;
        private SimpleDateFormat isdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private SimpleDateFormat isdf2 = new SimpleDateFormat("yyyy-MM-dd");

        public RptDateFormat(String pattern) {
            this.osdf = new SimpleDateFormat(pattern);
        }

        public String format(String data) throws Exception {
            if (data == null || data.length() == 0) {
                return "";
            }
            if (data.length() > 10) {
                return this.osdf.format(this.isdf.parse(String.valueOf(data)));
            }
            return this.osdf.format(this.isdf2.parse(String.valueOf(data)));
        }
    }

    public static final class RptNumberFormat {
        private static final String ZERO_STRING = "0000000000000000";
        private DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
        private int lastPrecision = -1;

        public String trimRedundantZero(String value) {
            if (value == null) {
                return null;
            }
            if (value.indexOf(46) == -1) {
                return value;
            }
            char[] chs = value.toCharArray();
            int n = chs.length;
            int j = n - 1;
            while (j > 0) {
                char ch = chs[j];
                if (ch != '0' && ch != ',') {
                    if (ch != '.') break;
                    n = j;
                    break;
                }
                n = j--;
            }
            if (n == chs.length) {
                return value;
            }
            return value.substring(0, n);
        }

        public String formatEmptyWithZero(String value, String precision) {
            return this.format(value, precision, true);
        }

        public String format(String value, String precision) {
            return this.format(value, precision, false);
        }

        public String format(String value, String precision, boolean zeroEmpty) {
            try {
                int p = Integer.parseInt(precision);
                if (this.lastPrecision != p) {
                    String pattern = "#,##0";
                    if (p > 0) {
                        pattern = pattern + "." + ZERO_STRING.substring(0, p);
                    }
                    this.df.applyPattern(pattern);
                    this.lastPrecision = p;
                }
                if (zeroEmpty && this.df.parse(value).doubleValue() == 0.0) {
                    return "";
                }
                return this.df.format(this.df.parse(value));
            }
            catch (Exception e) {
                return value;
            }
        }
    }

    static final class IllegalFormatExpress
    extends RuntimeException {
        IllegalFormatExpress(String msg) {
            super(msg);
        }
    }

    static final class TernaryFormatStmt
    extends FormatStmt {
        char[] chs;
        int i;
        int len;
        String cp;
        String cpValue;
        String matchValue;
        String missValue;
        private static Map TYPEMAP = new HashMap();
        private static final int TYPE_DEFAULT = 0;
        private static final int TYPE_SHORT = 1;
        private static final int TYPE_INTEGER = 2;
        private static final int TYPE_FLOAT = 3;
        private static final int TYPE_DOUBLE = 4;
        private static final int TYPE_BIGINTEGER = 5;
        private static final int TYPE_BIGDECIMAL = 6;
        private static final int CP_EQ = 0;
        private static final int CP_GT = 1;
        private static final int CP_LT = 2;
        private static final int CP_GE = 3;
        private static final int CP_LE = 4;
        private static final int CP_NE = 5;
        private static final String KEY_CP = ">=<!";
        private static final String KEY_SPLIT = "?:";
        private static Map CPMAP;

        TernaryFormatStmt(String format) {
            this.chs = format.toCharArray();
            this.i = 0;
            this.len = this.chs.length;
            this.parse();
        }

        private void parse() throws IllegalFormatExpress {
            this.match('@');
            this.cp = this.parseCP();
            this.cpValue = this.parseValue();
            this.match('?');
            this.matchValue = this.parseValue();
            this.match(':');
            this.missValue = this.parseValue();
        }

        private String parseCP() {
            char ch;
            StringBuffer sb = new StringBuffer(2);
            while (this.i < this.len && KEY_CP.indexOf(ch = this.chs[this.i++]) != -1) {
                sb.append(ch);
            }
            --this.i;
            return sb.toString();
        }

        private String parseValue() {
            char ch;
            StringBuffer sb = new StringBuffer();
            while (this.i < this.len && KEY_SPLIT.indexOf(ch = this.chs[this.i++]) == -1) {
                sb.append(ch);
            }
            --this.i;
            return sb.toString();
        }

        private void match(char ch) throws IllegalFormatExpress {
            if (ch != this.chs[this.i++]) {
                // empty if block
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CP=").append(this.cp).append("\tcpValue=").append(this.cpValue).append("\tmatchValue=").append(this.matchValue).append("\tmissValue=").append(this.missValue);
            return sb.toString();
        }

        private String getFormatValue(boolean match, Object data) {
            String patternValue = match ? this.matchValue : this.missValue;
            return patternValue.replaceAll("\\$_", RptCellFormatter.toObjectString(data));
        }

        private int getObjectType(Object value) {
            Integer typeValue = (Integer)TYPEMAP.get(value.getClass().getName());
            return typeValue == null ? 0 : typeValue;
        }

        @Override
        public String format(Object data) throws Exception {
            boolean match = false;
            if (data == null) {
                if ((Integer)CPMAP.get(this.cp) == 0 && (this.cpValue.length() == 0 || "null".equals(this.cpValue))) {
                    match = true;
                }
                return this.getFormatValue(match, data);
            }
            int type = this.getObjectType(data);
            Integer curCP = (Integer)CPMAP.get(this.cp);
            if (curCP == null) {
                return null;
            }
            block0 : switch (curCP) {
                case 0: {
                    switch (type) {
                        case 1: {
                            match = ((Short)data).intValue() == this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 2: {
                            match = ((Integer)data).intValue() == this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 3: {
                            match = ((Float)data).floatValue() == this.convertToFloat(this.cpValue);
                            break block0;
                        }
                        case 4: {
                            match = ((Double)data).doubleValue() == this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 5: {
                            match = ((BigInteger)data).intValue() == this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 6: {
                            match = ((BigDecimal)data).doubleValue() == this.convertToDouble(this.cpValue);
                            break block0;
                        }
                    }
                    match = RptCellFormatter.toObjectString(data).equals(this.cpValue);
                    break;
                }
                case 1: {
                    switch (type) {
                        case 1: {
                            match = ((Short)data).intValue() > this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 2: {
                            match = (Integer)data > this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 3: {
                            match = ((Float)data).floatValue() > this.convertToFloat(this.cpValue);
                            break block0;
                        }
                        case 4: {
                            match = (Double)data > this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 5: {
                            match = ((BigDecimal)data).doubleValue() > this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 6: {
                            match = ((BigDecimal)data).doubleValue() > this.convertToDouble(this.cpValue);
                            break block0;
                        }
                    }
                    match = RptCellFormatter.toObjectString(data).compareTo(this.cpValue) > 0;
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: {
                            match = ((Short)data).intValue() < this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 2: {
                            match = (Integer)data < this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 3: {
                            match = ((Float)data).floatValue() < this.convertToFloat(this.cpValue);
                            break block0;
                        }
                        case 4: {
                            match = (Double)data < this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 5: {
                            match = ((BigDecimal)data).doubleValue() < this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 6: {
                            match = ((BigDecimal)data).doubleValue() < this.convertToDouble(this.cpValue);
                            break block0;
                        }
                    }
                    match = RptCellFormatter.toObjectString(data).compareTo(this.cpValue) < 0;
                    break;
                }
                case 3: {
                    switch (type) {
                        case 1: {
                            match = ((Short)data).intValue() >= this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 2: {
                            match = (Integer)data >= this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 3: {
                            match = ((Float)data).floatValue() >= this.convertToFloat(this.cpValue);
                            break block0;
                        }
                        case 4: {
                            match = (Double)data >= this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 5: {
                            match = ((BigDecimal)data).doubleValue() >= this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 6: {
                            match = ((BigDecimal)data).doubleValue() >= this.convertToDouble(this.cpValue);
                            break block0;
                        }
                    }
                    match = RptCellFormatter.toObjectString(data).compareTo(this.cpValue) >= 0;
                    break;
                }
                case 4: {
                    switch (type) {
                        case 1: {
                            match = ((Short)data).intValue() <= this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 2: {
                            match = (Integer)data <= this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 3: {
                            match = ((Float)data).floatValue() <= this.convertToFloat(this.cpValue);
                            break block0;
                        }
                        case 4: {
                            match = (Double)data <= this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 5: {
                            match = ((BigDecimal)data).doubleValue() <= this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 6: {
                            match = ((BigDecimal)data).doubleValue() <= this.convertToDouble(this.cpValue);
                            break block0;
                        }
                    }
                    match = RptCellFormatter.toObjectString(data).compareTo(this.cpValue) <= 0;
                    break;
                }
                case 5: {
                    switch (type) {
                        case 1: {
                            match = ((Short)data).intValue() != this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 2: {
                            match = ((Integer)data).intValue() != this.convertToInt(this.cpValue);
                            break block0;
                        }
                        case 3: {
                            match = ((Float)data).floatValue() != this.convertToFloat(this.cpValue);
                            break block0;
                        }
                        case 4: {
                            match = ((Double)data).doubleValue() != this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 5: {
                            match = ((BigDecimal)data).doubleValue() != this.convertToDouble(this.cpValue);
                            break block0;
                        }
                        case 6: {
                            match = ((BigDecimal)data).doubleValue() != this.convertToDouble(this.cpValue);
                            break block0;
                        }
                    }
                    match = !RptCellFormatter.toObjectString(data).equals(this.cpValue);
                }
            }
            return this.getFormatValue(match, data);
        }

        private int convertToInt(String s) {
            return new Integer(s);
        }

        private float convertToFloat(String s) {
            return new Float(s).floatValue();
        }

        private double convertToDouble(String s) {
            return new Double(s);
        }

        static {
            TYPEMAP.put("java.lang.Short", new Integer(1));
            TYPEMAP.put("java.lang.Integer", new Integer(2));
            TYPEMAP.put("java.lang.Float", new Integer(3));
            TYPEMAP.put("java.lang.Double", new Integer(4));
            TYPEMAP.put("java.math.BigInteger", new Integer(5));
            TYPEMAP.put("java.math.BigDecimal", new Integer(6));
            CPMAP = new HashMap();
            CPMAP.put("=", new Integer(0));
            CPMAP.put(">", new Integer(1));
            CPMAP.put("<", new Integer(2));
            CPMAP.put(">=", new Integer(3));
            CPMAP.put("<=", new Integer(4));
            CPMAP.put("<>", new Integer(5));
            CPMAP.put("!=", new Integer(5));
        }
    }

    static final class FunctionFormatStmt
    extends FormatStmt {
        String cl;
        String[] clp;
        String m;
        String[] p;
        int i = 0;
        char[] chs;
        Object bean;
        Method method;

        FunctionFormatStmt(String format) {
            this.chs = format.toCharArray();
            this.parse();
        }

        private void parse() throws IllegalFormatExpress {
            this.match('@');
            this.match('f');
            this.match('(');
            this.cl = this.parseClass();
            this.clp = this.parseConstructorParams();
            this.m = this.parseMethodName();
            this.p = this.parseMethodParams();
            this.match(')');
        }

        private String parseClass() {
            StringBuffer sb = new StringBuffer();
            while (true) {
                char ch;
                if ((ch = this.next()) == '#' || ch == '(') break;
                sb.append(ch);
            }
            this.back();
            return sb.toString();
        }

        private String[] parseConstructorParams() {
            if (!this.nextIs('(')) {
                return null;
            }
            this.next();
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            boolean end = false;
            block4: do {
                char ch = this.next();
                switch (ch) {
                    case ',': {
                        list.add(sb.toString());
                        sb.setLength(0);
                        break;
                    }
                    case ')': {
                        end = true;
                        if (sb.length() <= 0) continue block4;
                        list.add(sb.toString());
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            } while (!end);
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }

        private String parseMethodName() {
            char ch;
            this.match('#');
            StringBuffer sb = new StringBuffer();
            while ((ch = this.next()) != ',') {
                sb.append(ch);
            }
            return sb.toString();
        }

        private String[] parseMethodParams() {
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            boolean end = false;
            do {
                char ch = this.next();
                switch (ch) {
                    case ',': {
                        list.add(sb.toString());
                        sb.setLength(0);
                        break;
                    }
                    case ')': {
                        end = true;
                        if (sb.length() > 0) {
                            list.add(sb.toString());
                        }
                        this.back();
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            } while (!end);
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }

        private void back() {
            --this.i;
        }

        private char next() {
            return this.chs[this.i++];
        }

        private boolean nextIs(char ch) {
            return ch == this.chs[this.i];
        }

        private void match(char ch) throws IllegalFormatExpress {
            if (ch != this.chs[this.i++]) {
                throw new IllegalFormatExpress("expect the " + ch + " but meet " + this.chs[this.i - 1]);
            }
        }

        @Override
        public String format(Object data) throws Exception {
            if (this.method == null) {
                Object[] cls;
                if (this.clp == null || this.clp.length == 0) {
                    this.bean = Class.forName(this.cl).newInstance();
                } else {
                    cls = new Class[this.clp.length];
                    Arrays.fill(cls, String.class);
                    this.bean = Class.forName(this.cl).getConstructor((Class<?>[])cls).newInstance(this.clp);
                }
                cls = new Class[this.p.length];
                Arrays.fill(cls, String.class);
                this.method = this.bean.getClass().getDeclaredMethod(this.m, (Class<?>[])cls);
            }
            int n = this.p.length;
            Object[] params = new String[n];
            for (int i = 0; i < n; ++i) {
                params[i] = this.p[i].replaceAll("\\$_", RptCellFormatter.toObjectString(data));
            }
            return (String)this.method.invoke(this.bean, params);
        }
    }

    static abstract class FormatStmt {
        FormatStmt() {
        }

        public abstract String format(Object var1) throws Exception;
    }
}

