/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtility {
    static final char LFLOWER = '{';
    static final char OR = '|';
    static final char STAR = '*';
    static final char PLUS = '+';
    static final char QUESTION = '?';
    static final char LPAREN = '(';
    static final char RPAREN = ')';
    static final char DOT = '.';
    static final char LBRACKET = '[';
    static final char BACKSOLIDUS = '\\';
    static final char CARET = '^';
    static final char DOLLAR = '$';

    public static String toHexString(String aString) {
        String retVal = "";
        StringBuffer sb = new StringBuffer();
        char[] c = new char[aString.length()];
        for (int i = 0; i < aString.length(); ++i) {
            c[i] = aString.charAt(i);
            sb.append("\\u");
            String temp = Integer.toHexString(c[i]);
            for (int j = 4; j > temp.length(); --j) {
                sb.append("0");
            }
            sb.append(temp);
        }
        retVal = sb.toString();
        return retVal;
    }

    public static boolean isMatch(String source, String target, boolean isMistiness) {
        return StringUtility.isMatch(source, target, isMistiness, 128);
    }

    public static boolean isMatch(String source, String target, boolean isMistiness, int flag) {
        boolean ismatch = false;
        String aSource = source;
        Pattern patt = null;
        if (isMistiness) {
            patt = Pattern.compile(StringUtility.toHexString(target) + "[.]*", flag);
        } else {
            if (source.length() != target.length()) {
                return false;
            }
            patt = Pattern.compile(StringUtility.toHexString(target), flag);
        }
        Matcher matcher = patt.matcher(source);
        ismatch = matcher.find();
        return ismatch;
    }

    public static String[] setToArray(Set set) {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        Object[] objs = set.toArray();
        String[] ret = new String[objs.length];
        System.arraycopy(objs, 0, ret, 0, objs.length);
        return ret;
    }

    public static String[] listToArray(List list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        Object[] objs = list.toArray();
        String[] ret = new String[objs.length];
        System.arraycopy(objs, 0, ret, 0, objs.length);
        return ret;
    }

    public static String castRegular(String s) {
        StringBuffer ret = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '{': {
                    ret.append('\\');
                    break;
                }
                case '|': {
                    ret.append('\\');
                    break;
                }
                case '*': {
                    ret.append('\\');
                    break;
                }
                case '+': {
                    ret.append('\\');
                    break;
                }
                case '?': {
                    ret.append('\\');
                    break;
                }
                case '(': {
                    ret.append('\\');
                    break;
                }
                case ')': {
                    ret.append('\\');
                    break;
                }
                case '.': {
                    ret.append('\\');
                    break;
                }
                case '[': {
                    ret.append('\\');
                    break;
                }
                case '\\': {
                    ret.append('\\');
                    break;
                }
                case '^': {
                    ret.append('\\');
                    break;
                }
                case '$': {
                    ret.append('\\');
                    break;
                }
            }
            ret.append(chars[i]);
        }
        return ret.toString();
    }

    public static boolean isNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(str.trim());
        }
        catch (Exception E) {
            return false;
        }
        return true;
    }

    public static int compareValue(String value, double douVal) {
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            double douValue = Double.parseDouble(value.trim());
            if (douValue > douVal) {
                return 1;
            }
            if (douValue < douVal) {
                return -1;
            }
        }
        catch (Exception E) {
            return 0;
        }
        return 0;
    }

    public static boolean isLetter(char c) {
        int k = 128;
        return c / k == 0;
    }

    public static int length(String s) {
        if (s == null) {
            return 0;
        }
        char[] c = s.toCharArray();
        int len = 0;
        for (int i = 0; i < c.length; ++i) {
            ++len;
            if (StringUtility.isLetter(c[i])) continue;
            ++len;
        }
        return len;
    }

    public static String substring(String origin, int len) {
        if (origin == null || origin.equals("") || len < 1) {
            return "";
        }
        byte[] strByte = new byte[len];
        if (len > StringUtility.length(origin)) {
            return origin;
        }
        System.arraycopy(origin.getBytes(), 0, strByte, 0, len);
        int count = 0;
        for (int i = 0; i < len; ++i) {
            byte value = strByte[i];
            if (value >= 0) continue;
            ++count;
        }
        if (count % 2 != 0) {
            len = len == 1 ? ++len : --len;
        }
        return new String(strByte, 0, len);
    }
}

