/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ILocalBOSObjectFactory;
import com.kingdee.bos.IRemoteBOSObjectFactory;
import com.kingdee.bos.LocalBOSObjectFactory;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.util.BOSObjectType;

public class BOSObjectFactory {
    private static final ThreadLocal<Context> threadCx = new ThreadLocal();

    private BOSObjectFactory() {
    }

    public static void setContextToThread(Context context) {
        threadCx.set(context);
    }

    public static Context getContextFromThread() {
        return threadCx.get();
    }

    public static void clearSession(String rpcUrl) {
        BOSObjectFactory.getRemoteBOSObjectFactory(rpcUrl).clearSession();
    }

    public static IBOSObject createRemoteBOSObject(BOSObjectType bosType, Class model) throws BOSException {
        Context objectCtx = BOSObjectFactory.getContextFromThread();
        if (objectCtx == null) {
            return GeniusBOSFactory.createRemoteBOSObject(bosType, model);
        }
        return GeniusBOSFactory.createRemoteBOSObjectWithObjectContext(bosType, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObjectWithObjectContext(BOSObjectType bosType, Class model, Context objectCtx) throws BOSException {
        return GeniusBOSFactory.createRemoteBOSObjectWithObjectContext(bosType, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObject(String className, Class model) throws BOSException {
        Context objectCtx = BOSObjectFactory.getContextFromThread();
        if (objectCtx == null) {
            return GeniusBOSFactory.createRemoteBOSObject(className, model);
        }
        return GeniusBOSFactory.createRemoteBOSObjectWithObjectContext(className, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObjectWithObjectContext(String className, Class model, Context objectCtx) throws BOSException {
        return GeniusBOSFactory.createRemoteBOSObjectWithObjectContext(className, model, objectCtx);
    }

    public static IORMModel createRemoteObject(String className, Class model, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        return GeniusBOSFactory.createRemoteObject(className, model, initArgTypes, initArgValues);
    }

    public static IBOSObject createRemoteBOSObject(String rpcURL, BOSObjectType bosType, Class model) throws BOSException {
        return BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createBOSObject(bosType, model);
    }

    public static IBOSObject createRemoteBOSObject(String rpcURL, BOSObjectType bosType, Class model, Context objectCtx) throws BOSException {
        return BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createBOSObject(bosType, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObject(String rpcURL, String className, Class model) throws BOSException {
        Context objectCtx = BOSObjectFactory.getContextFromThread();
        if (objectCtx == null) {
            return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createObject(className, model);
        }
        return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createObject(className, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObjectWithObjectContext(String rpcURL, String className, Class model, Context objectCtx) throws BOSException {
        return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createObject(className, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObject(String rpcURL, String className, Class model, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createObject(className, model, initArgTypes, initArgValues);
    }

    public static IBOSObject createBOSObject(Context ctx, BOSObjectType bosType) throws BOSException {
        return BOSObjectFactory.getLocalBOSObjectFactory(ctx).createBOSObject(bosType);
    }

    public static IBOSObject createBOSObject(Context ctx, String className) throws BOSException {
        return BOSObjectFactory.getLocalBOSObjectFactory(ctx).createBOSObject(className);
    }

    public static IBOSObject createBOSObject(Context ctx, String className, Class model) throws BOSException {
        return BOSObjectFactory.getLocalBOSObjectFactory(ctx).createBOSObject(className, model);
    }

    public static IBOSObject createBOSObject(String sessionID, BOSObjectType bosType) throws BOSException {
        return BOSObjectFactory.getLocalBOSObjectFactory(sessionID).createBOSObject(bosType);
    }

    public static IBOSObject createBOSObject(String sessionID, String className) throws BOSException {
        return BOSObjectFactory.getLocalBOSObjectFactory(sessionID).createBOSObject(className);
    }

    public static IORMModel createRemoteObject(String rpcUrl, String objName, Class className) throws BOSException {
        return BOSObjectFactory.getRemoteBOSObjectFactory(rpcUrl).createObject(objName, className);
    }

    public static IORMModel createRemoteObject(String rpcUrl, String objName, Class className, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        return BOSObjectFactory.getRemoteBOSObjectFactory(rpcUrl).createObject(objName, className, initArgTypes, initArgValues);
    }

    public static IRemoteBOSObjectFactory getRemoteBOSObjectFactory(String rpcUrl) {
        return RemoteBOSObjectFactory.getInstance(rpcUrl);
    }

    public static ILocalBOSObjectFactory getLocalBOSObjectFactory(String sessionID) {
        return LocalBOSObjectFactory.getInstance(sessionID);
    }

    public static ILocalBOSObjectFactory getLocalBOSObjectFactory(Context ctx) {
        return LocalBOSObjectFactory.getInstance(ctx);
    }

    public static IBOSObject createCommonBOSObject(Context ctx, IMetaDataPK pk) throws BOSException {
        return BOSObjectFactory.getLocalBOSObjectFactory(ctx).createCommonBOSObject(pk);
    }

    public static IBOSObject createRemoteCommonBOSObject(IMetaDataPK pk) throws BOSException {
        Context objectCtx = BOSObjectFactory.getContextFromThread();
        if (objectCtx == null) {
            return GeniusBOSFactory.createRemoteCommonBOSObject(pk);
        }
        return GeniusBOSFactory.createRemoteCommonBOSObjectWithObjectContext(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObject(String rpcURL, IMetaDataPK pk) throws BOSException {
        Context objectCtx = BOSObjectFactory.getContextFromThread();
        if (objectCtx == null) {
            return BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createCommonBOSObject(pk);
        }
        return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createCommonObject(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObject(IMetaDataPK pk, Context objectCtx) throws BOSException {
        return GeniusBOSFactory.createRemoteCommonBOSObject(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObject(String rpcURL, IMetaDataPK pk, Context objectCtx) throws BOSException {
        return BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createCommonBOSObject(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObjectWithObjectContext(IMetaDataPK pk, Context objectCtx) throws BOSException {
        return GeniusBOSFactory.createRemoteCommonBOSObjectWithObjectContext(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObjectWithObjectContext(String rpcURL, IMetaDataPK pk, Context objectCtx) throws BOSException {
        return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createCommonObject(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObject(IMetaDataPK pk, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        return GeniusBOSFactory.createRemoteCommonBOSObject(pk, initArgTypes, initArgValues);
    }

    public static IBOSObject createRemoteCommonBOSObject(String rpcURL, IMetaDataPK pk, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        return (IBOSObject)BOSObjectFactory.getRemoteBOSObjectFactory(rpcURL).createCommonObject(pk, initArgTypes, initArgValues);
    }
}

