/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.Context;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class ContextUtils {
    public static final String SESSIONID = "bos_sessionid";
    private static LocalePair nl = null;
    private static final ThreadLocal<LocalePair> threadNl = new ThreadLocal();

    public static Context getContextFromSession() {
        RPCServerSession rpcServerSession = RPCEngine.getCurrentServerSession();
        if (rpcServerSession == null) {
            throw new IllegalSessionStateException("rpcServerSession is null,Please login first!");
        }
        String sessionID = (String)rpcServerSession.getContext((Object)SESSIONID);
        if (sessionID == null) {
            throw new IllegalSessionStateException("Please login first!");
        }
        ISessionManager manager = SessionManager.getInstance();
        SessionInfo sessionInfo = manager.getSession(sessionID);
        if (sessionInfo == null) {
            throw new IllegalSessionStateException("Cannot found session info! sessionID is " + sessionID);
        }
        Context tmpCtx = null;
        tmpCtx = sessionInfo.getContext();
        if (tmpCtx == null) {
            throw new IllegalSessionStateException("Cannot found context in session! sessionID is " + sessionID);
        }
        return tmpCtx;
    }

    public static Context getContextFromSessionNoException() {
        RPCServerSession rpcServerSession = RPCEngine.getCurrentServerSession();
        if (rpcServerSession == null) {
            return null;
        }
        String sessionID = (String)rpcServerSession.getContext((Object)SESSIONID);
        if (sessionID == null) {
            return null;
        }
        ISessionManager manager = SessionManager.getInstance();
        SessionInfo sessionInfo = manager.getSession(sessionID);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getContext();
    }

    public static void setLocaleToEnv(Locale l) {
        if (!StringUtils.isEmpty((String)LocaleUtils.getLocaleString((Locale)l))) {
            nl = new LocalePair(l);
        }
    }

    public static void setLocaleToThread(Locale l) {
        threadNl.set(new LocalePair(l));
    }

    public static Locale getLocaleFromEnv() {
        return ContextUtils.innerGetLocaleFromEnv(false);
    }

    private static Locale innerGetLocaleFromEnv(boolean isOrigin) {
        Context ctx = ContextUtils.getContextFromSessionNoException();
        if (ctx != null) {
            if (isOrigin) {
                return ctx.getOriginLocale();
            }
            return ctx.getLocale();
        }
        try {
            LocalePair obj = threadNl.get();
            if (obj != null) {
                if (isOrigin) {
                    return obj.originLocale;
                }
                return obj.locale;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (nl != null) {
            if (isOrigin) {
                return ContextUtils.nl.originLocale;
            }
            return ContextUtils.nl.locale;
        }
        if (isOrigin) {
            return ContextManager.getContext().getOriginLocale();
        }
        return ContextManager.getContext().getLocale();
    }

    public static Locale getOriginalLocaleFromEnv() {
        return ContextUtils.innerGetLocaleFromEnv(true);
    }

    private static class LocalePair {
        final Locale locale;
        final Locale originLocale;

        LocalePair(Locale locale) {
            this.locale = LocaleUtils.getShortLocale((Locale)locale);
            this.originLocale = LocaleUtils.getFirstOriginLocale((Locale)locale);
        }
    }
}

