/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.BOSClassNotFoundException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ICommonType;
import com.kingdee.bos.ILocalBOSObjectFactory;
import com.kingdee.bos.MissingMetaDataException;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

class LocalBOSObjectFactory
implements ILocalBOSObjectFactory {
    private final Context ctx;

    public static LocalBOSObjectFactory getInstance(Context ctx) {
        return new LocalBOSObjectFactory(ctx);
    }

    public static LocalBOSObjectFactory getInstance(String sessionID) {
        return LocalBOSObjectFactory.getInstance(SessionManager.getInstance().getSession(sessionID).getContext());
    }

    private LocalBOSObjectFactory(Context ctx) {
        if (ctx == null) {
            throw new IllegalStateException("context is null!");
        }
        this.ctx = ctx;
    }

    @Override
    public IBOSObject createBOSObject(BOSObjectType type) throws BOSException {
        String ctrlClass = null;
        String interfaceClass = null;
        if (type.equals((Object)MetaDataTypeList.DATATABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.DataTableCtrl";
        } else if (type.equals((Object)MetaDataTypeList.ABSTRACTTABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.AbstractTableCtrl";
        } else if (type.equals((Object)MetaDataTypeList.CROSSTABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.CrossTableCtrl";
        } else if (type.equals((Object)MetaDataTypeList.EXTENDEDTABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.ExtendedTableCtrl";
        } else if (type.equals((Object)MetaDataTypeList.SOLUTION)) {
            ctrlClass = "com.kingdee.bos.metadata.management.SolutionCtrl";
        } else if (type.equals((Object)MetaDataTypeList.APPVIEW)) {
            ctrlClass = "com.kingdee.bos.metadata.management.application.AppViewCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZENUM)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.BizEnumCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZEXCEPTION)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.BizExceptionCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZDATATYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.BizDataTypeCtrl";
        } else if (type.equals((Object)MetaDataTypeList.PACKAGE)) {
            ctrlClass = "com.kingdee.bos.metadata.management.PackageCtrl";
        } else if (type.equals((Object)MetaDataTypeList.ENTITY)) {
            ctrlClass = "com.kingdee.bos.metadata.entity.EntityObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZRULESET)) {
            ctrlClass = "com.kingdee.bos.metadata.bizrule.RuleSetCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZUNIT)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizUnitCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZTEMPLATE)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizTemplateCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZFIELDTEMPLATESET)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizFieldTemplateSetCtrl";
        } else if (type.equals((Object)MetaDataTypeList.DATAX)) {
            ctrlClass = "com.kingdee.bos.metadata.datax.DataXCtrl";
        } else if (type.equals((Object)MetaDataTypeList.REPORT)) {
            ctrlClass = "com.kingdee.bos.metadata.report.ReportCtrl";
        } else if (type.equals((Object)MetaDataTypeList.UIOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.ui.UIObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.FACADE)) {
            ctrlClass = "com.kingdee.bos.metadata.facade.FacadeCtrl";
        } else if (type.equals((Object)MetaDataTypeList.WORKFLOW)) {
            ctrlClass = "com.kingdee.bos.workflow.wfdesigner.WorkFlowCtrl";
        } else if (type.equals((Object)MetaDataTypeList.RELATIONSHIP)) {
            ctrlClass = "com.kingdee.bos.metadata.entity.RelationshipCtrl";
        } else if (type.equals((Object)MetaDataTypeList.FUNCTION)) {
            ctrlClass = "com.kingdee.bos.metadata.function.FunctionObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.JOINQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.JoinQueryCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BASEQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.QueryCtrl";
        } else if (type.equals((Object)MetaDataTypeList.UNIONQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.UnionQueryCtrl";
        } else if (type.equals((Object)MetaDataTypeList.VIRTUALQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.VirtualQueryCtrl";
        } else if (type.equals((Object)MetaDataTypeList.RULE)) {
            ctrlClass = "com.kingdee.bos.metadata.rule.RuleCtrl";
        } else if (type.equals((Object)MetaDataTypeList.MULTILANGUAGE)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.I18nResourceCtrl";
        } else if (type.equals((Object)MetaDataTypeList.IMAGE_RESOURCE_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.ImageResourceCtrl";
        } else if (type.equals((Object)MetaDataTypeList.PERMISSION)) {
            ctrlClass = "com.kingdee.bos.service.permission.metadata.PermissionCtrl";
        } else if (type.equals((Object)MetaDataTypeList.MDQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.mdquery.MDQueryCtrl";
        } else if (type.equals((Object)MetaDataTypeList.MUTEX)) {
            ctrlClass = "com.kingdee.bos.service.mutex.MutexCtrl";
        } else if (type.equals((Object)MetaDataTypeList.EVENT_FOR_WF)) {
            ctrlClass = "com.kingdee.bos.metadata.event.EventCtrl";
        } else if (type.equals((Object)MetaDataTypeList.LOG)) {
            ctrlClass = "com.kingdee.bos.service.log.define.LogCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BOTMAPPING)) {
            ctrlClass = "com.kingdee.bos.metadata.bot.BOTMappingCtrl";
        } else if (type.equals((Object)MetaDataTypeList.METADATABRIEFVIEW)) {
            ctrlClass = "com.kingdee.bos.metadata.view.MetaDataBriefViewCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BASE_TEMPLATE_REF_SET)) {
            ctrlClass = "com.kingdee.bos.metadata.management.BaseTemplateRefSetCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZRULESET)) {
            ctrlClass = "com.kingdee.bos.metadata.bizrule.RuleSetCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZUNIT)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizUnitCtrl";
        } else if (type.equals((Object)MetaDataTypeList.BIZTEMPLATE)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizUnitCtrl";
        } else if (type.equals((Object)MetaDataTypeList.INTEGRATION_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.eai.IntegrationCtrl";
        } else if (type.equals((Object)MetaDataTypeList.APPLICATION_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.eai.ApplicationCtrl";
        } else if (type.equals((Object)MetaDataTypeList.APPLICATION_NODE_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.eai.ApplicationNodeCtrl";
        } else if (type.equals((Object)MetaDataTypeList.WEBUIOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webui.WebUIObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.LOGIN)) {
            ctrlClass = "com.kingdee.bos.framework.session.LoginModule";
        } else if (type.equals((Object)MetaDataTypeList.WEBPAGEOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webpage.WebPageObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.WEBCOMPONENTOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webcomponent.WebComponentObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.WEBCONTROLOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webcontrol.WebControlObjectCtrl";
        } else if (type.equals((Object)MetaDataTypeList.WEBRULE)) {
            ctrlClass = "com.kingdee.bos.metadata.webrule.WebRuleCtrl";
        } else if (type.equals((Object)MetaDataTypeList.WEBMACRO)) {
            ctrlClass = "com.kingdee.bos.metadata.webmacro.WebMacroCtrl";
        } else {
            BusinessObjectInfo meta = MetaDataLoaderFactory.getLocalMetaDataLoader(this.ctx).getBusinessObject(type);
            if (meta == null) {
                throw new MissingMetaDataException("LocalBOSObjectFacory: Cannot load metadata from cache: [" + type + "]");
            }
            if (meta instanceof EntityObjectInfo && !((EntityObjectInfo)meta).getIsGenerateCode()) {
                return this.createCommonBOSObject(MetaDataPK.create(meta.getFullName()));
            }
            ctrlClass = meta.getBusinessImplName();
            interfaceClass = meta.getBusinessInterface();
        }
        if (ctrlClass == null) {
            throw new IllegalStateException("Please process bostype " + type + " at LocalBOSObjectFactory");
        }
        Class<?> model = null;
        if (interfaceClass != null) {
            try {
                model = Class.forName(interfaceClass);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException("interfaceClass " + interfaceClass + " not Found", (Throwable)e);
            }
        }
        return this.createBOSObject(ctrlClass, model);
    }

    @Override
    public IBOSObject createBOSObject(String ctrlClass) throws BOSException {
        return this.createBOSObject(ctrlClass, null);
    }

    @Override
    public IBOSObject createBOSObject(String ctrlClass, Class model) throws BOSException {
        return this.createBOSObject(ctrlClass, model, null, null);
    }

    private IBOSObject createBOSObject(String ctrlClass, Class model, IMetaDataPK pk, BOSObjectType type) throws BOSException {
        if (ctrlClass == null) {
            throw new IllegalStateException();
        }
        Class interfaceClazz = model;
        try {
            Class<?> obj = Class.forName(ctrlClass);
            IBOSObject o = (IBOSObject)obj.getConstructor(Context.class).newInstance(this.ctx);
            if (pk != null && o instanceof ICommonType) {
                ((ICommonType)((Object)o)).setPK(pk);
            }
            if (type != null && o instanceof ICommonType) {
                ((ICommonType)((Object)o)).setType(type);
            }
            if (interfaceClazz != null) {
                Class<?> clazz = Class.forName("com.kingdee.bos.ResponseInvocationHandler");
                InvocationHandler invocationHandler = (InvocationHandler)clazz.getConstructor(Class.class, Object.class, Context.class).newInstance(interfaceClazz, o, this.ctx);
                o = (IBOSObject)Proxy.newProxyInstance(interfaceClazz.getClassLoader(), new Class[]{interfaceClazz}, invocationHandler);
            }
            if (ProfileConfig.getInstance().logLocalObject && interfaceClazz != null) {
                return (IBOSObject)Proxy.newProxyInstance(interfaceClazz.getClassLoader(), new Class[]{interfaceClazz}, (InvocationHandler)new ObjectProfileInterceptor((Object)o));
            }
            return o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BOSClassNotFoundException(cnfe);
        }
        catch (Exception e) {
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            throw new ReflectException(e);
        }
    }

    @Override
    public IBOSObject createCommonBOSObject(IMetaDataPK pk) throws BOSException {
        String ctrlClass = null;
        String interfaceClass = null;
        BusinessObjectInfo meta = (BusinessObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader(this.ctx).get(MetaDataTypeList.ENTITY, pk);
        if (meta == null) {
            throw new MissingMetaDataException("LocalBOSObjectFactory: Cannot load metadata for: pk[" + pk + "]");
        }
        ctrlClass = meta.getBusinessImplName();
        interfaceClass = meta.getBusinessInterface();
        if (ctrlClass == null) {
            throw new IllegalStateException("Please process pk " + pk + " at LocalBOSObjectFactory");
        }
        Class<?> model = null;
        if (interfaceClass != null) {
            try {
                model = Class.forName(interfaceClass);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException("interfaceClass " + interfaceClass + " not Found", (Throwable)e);
            }
        }
        IBOSObject rtv = this.createBOSObject(ctrlClass, model, pk, meta.getType());
        return rtv;
    }
}

