/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao;

import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.util.IPropertyChange;
import com.kingdee.util.Null;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractObjectCollection
extends AbstractBaseObjectCollection
implements IPropertyChange {
    private static final long serialVersionUID = -7404429107164795377L;
    protected transient List oldList = null;
    protected transient boolean avalilable = true;

    public AbstractObjectCollection() {
        this((Class)null);
    }

    public AbstractObjectCollection(int initialCapacity) {
        super(initialCapacity);
    }

    protected AbstractObjectCollection(Class itemType) {
        super(itemType);
    }

    public boolean isValueChange() {
        if (!this.isAvailable()) {
            return false;
        }
        return !((Object)this.oldList).equals(this.list);
    }

    public void resetValue() {
        if (!this.isAvailable()) {
            return;
        }
        if (this.oldList == null) {
            return;
        }
        for (int i = 0; i < this.oldList.size(); ++i) {
            IPropertyChange change = (IPropertyChange)this.oldList.get(i);
            change.resetValue();
        }
        this.list.clear();
        this.list.addAll(this.oldList);
    }

    public void copyNewToOld() {
        if (!this.isAvailable()) {
            return;
        }
        if (this.oldList == null) {
            this.oldList = new ArrayList(this.list.size());
        }
        for (int i = 0; i < this.list.size(); ++i) {
            IPropertyChange change = (IPropertyChange)this.list.get(i);
            change.copyNewToOld();
        }
        this.oldList.clear();
        this.oldList.addAll(this.list);
    }

    public void setAvailable(boolean avalilable) {
        this.avalilable = avalilable;
    }

    public boolean isAvailable() {
        return this.avalilable;
    }

    public boolean compareNewToOld() {
        return AbstractObjectCollection.compare(this.list, this.oldList);
    }

    private static boolean compare(List value1, List value2) {
        if (AbstractObjectCollection.isEmptyObject(value1) && AbstractObjectCollection.isEmptyObject(value2)) {
            return true;
        }
        if (value1.size() != value2.size()) {
            return false;
        }
        ListIterator e1 = value1.listIterator();
        int index = 0;
        while (e1.hasNext()) {
            Object o1 = e1.next();
            if (o1 instanceof AbstractObjectValue) {
                boolean isEqual;
                AbstractObjectValue v1 = (AbstractObjectValue)o1;
                Object o2 = value2.get(index);
                if (o2 == null) {
                    return false;
                }
                if (o1 != o2) {
                    AbstractObjectValue v2 = (AbstractObjectValue)o2;
                    v1.setOldValues(v2.oldValues);
                }
                if (!(isEqual = v1.compareNewToOld())) {
                    return false;
                }
            } else {
                return false;
            }
            ++index;
        }
        return true;
    }

    public void setSyncOldValue(boolean syncOldValue) {
        for (AbstractObjectValue value : this.list) {
            value.setSyncOldValue(syncOldValue);
        }
    }

    private static boolean isEmptyObject(Object s) {
        if (s == null || s == Null.NULL) {
            return true;
        }
        if (s instanceof List) {
            return ((List)s).size() == 0;
        }
        return false;
    }
}

