/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.PropertyValidateFailedException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.ConstraintInfo;
import com.kingdee.bos.metadata.entity.NumericConstraintInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RegexConstraintInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.util.ScriptUtil;
import com.kingdee.util.StringUtils;

public class PropertyConstriantValidator {
    private static boolean checkRegexConstraint(Object value, String regex) {
        String strValue = null;
        if (value != null) {
            strValue = StringUtils.replace((String)value.toString(), (String)"\\", (String)"\\\\");
            strValue = StringUtils.replace((String)strValue, (String)"'", (String)"\\'");
        }
        regex = StringUtils.replace((String)regex, (String)"\\", (String)"\\\\");
        StringBuffer script = new StringBuffer();
        if (strValue == null) {
            script.append("var str = null;");
        } else {
            script.append("var str = '").append(strValue).append("';");
        }
        script.append("var re = new RegExp('").append(regex).append("');").append("if (str.match(re))").append("    true;").append("else ").append("    false;");
        Object b = ScriptUtil.evalExpr((String)script.toString(), null);
        return b == null || !b.toString().equals("false");
    }

    public static void validateProperty(OwnPropertyInfo prop, Object value) throws PropertyValidateFailedException {
        PropertyConstriantValidator.validateProperty(null, prop, value);
    }

    public static void validateProperty(Context ctx, OwnPropertyInfo prop, Object value) throws PropertyValidateFailedException {
        PropertyConstriantValidator.validateConstraint(ctx, prop.getConstraint(), value);
    }

    public static void validateConstraint(Context ctx, ConstraintInfo constraint, Object value) throws PropertyValidateFailedException {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof NumericConstraintInfo) {
            NumericConstraintInfo nc = (NumericConstraintInfo)constraint;
            if (nc.getMaxValue() != null && nc.getMaxValue().length() != 0 && Float.compare(Float.parseFloat(value.toString()), Float.parseFloat(nc.getMaxValue())) > 0) {
                throw new PropertyValidateFailedException(PropertyConstriantValidator.getMessage(ctx, constraint));
            }
            if (nc.getMinValue() != null && nc.getMinValue().length() != 0 && Float.compare(Float.parseFloat(value.toString()), Float.parseFloat(nc.getMinValue())) < 0) {
                throw new PropertyValidateFailedException(PropertyConstriantValidator.getMessage(ctx, constraint));
            }
        } else if (constraint instanceof RegexConstraintInfo) {
            RegexConstraintInfo rc = (RegexConstraintInfo)constraint;
            try {
                if (!PropertyConstriantValidator.checkRegexConstraint(value, rc.getRegex())) {
                    throw new PropertyValidateFailedException(PropertyConstriantValidator.getMessage(ctx, constraint));
                }
            }
            catch (Exception e) {
                throw new PropertyValidateFailedException(PropertyConstriantValidator.getMessage(ctx, constraint));
            }
        }
    }

    private static String getMessage(Context ctx, ConstraintInfo constraint) {
        String msg = constraint.getMessage();
        if (ctx != null) {
            SolutionInfo slnInfo = MetaDataLoaderFactory.getMetaDataLoader(ctx).getSolution();
            if (!ctx.getLocale().toString().equalsIgnoreCase(slnInfo.getDefaultLanguage().getPostfix())) {
                msg = constraint.getMessage(ctx.getLocale());
            }
        }
        return msg;
    }
}

