/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetadataHandle;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.RefImpl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class BinaryStore {
    private final Context ctx;
    private File saveDir;

    private static void serializeMetadata(AbstractMetaDataValue info, OutputStream os) throws DataAccessException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(info);
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public BinaryStore(Context ctx, String savePath) {
        this.ctx = ctx;
        this.saveDir = new File(savePath);
    }

    public void store(IObjectValue info) throws DataAccessException {
        try {
            this.handleLinkObjects((AbstractMetaDataValue)info);
            BinaryStore.serializeMetadata((AbstractMetaDataValue)info, this.getStoreStream4Metadata((AbstractMetaDataValue)info));
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    private OutputStream getStoreStream4Metadata(AbstractMetaDataValue vo) throws IOException {
        String pkg = vo.getPackage();
        File dir = this.saveDir;
        if (!StringUtils.isEmpty((String)pkg)) {
            String dirPath = pkg.replace('.', File.separatorChar);
            dir = new File(this.saveDir, dirPath);
            dir.mkdirs();
        }
        File mf = new File(dir, vo.getName() + Utils.getMetaDataSuffix(vo.getBOSType()));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mf));
        return os;
    }

    private void handleLinkObjects(AbstractMetaDataValue info) throws DataAccessException {
        IdentityHashMap seen = new IdentityHashMap();
        HashMap cache = new HashMap();
        this.handleLinkObjects0(info, seen, cache);
    }

    private void handleLinkObjects0(IObjectValue info, Map seen, Map cache) throws DataAccessException {
        if (info == null) {
            return;
        }
        Enumeration keys = info.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = info.get(key);
            if (value instanceof IObjectCollection) {
                IObjectCollection vs = (IObjectCollection)value;
                for (int i = 0; i < vs.size(); ++i) {
                    IObjectValue v = vs.getObject(i);
                    if (v instanceof AbstractMetaDataValue) {
                        if (!(v instanceof IMetadataHandle)) continue;
                        vs.setObject(i, (IObjectValue)((Object)this.object2handle((AbstractMetaDataValue)v, cache)));
                        continue;
                    }
                    if (!(v instanceof IObjectValue) || seen.containsKey(v)) continue;
                    seen.put(v, null);
                    this.handleLinkObjects0(v, seen, cache);
                }
                continue;
            }
            if (value instanceof AbstractMetaDataValue) {
                info.put(key, this.object2handle((AbstractMetaDataValue)value, cache));
                continue;
            }
            if (!(value instanceof IObjectValue) || seen.containsKey(value)) continue;
            seen.put(value, null);
            this.handleLinkObjects0((IObjectValue)value, seen, cache);
        }
    }

    private IMetadataHandle object2handle(AbstractMetaDataValue info, Map cache) throws DataAccessException {
        String key = info.getFullName() + Utils.getMetaDataSuffix(info.getBOSType());
        if (cache.containsKey(key)) {
            return (IMetadataHandle)cache.get(key);
        }
        EntityObjectInfo meta = XMLAccessEngine.loadMeta(this.ctx, info);
        String className = meta.getObjectValueClass();
        String handleClass = className + "Handle";
        try {
            Class<?> c = Class.forName(handleClass, false, info.getClass().getClassLoader());
            IMetadataHandle h = (IMetadataHandle)c.newInstance();
            RefImpl r = new RefImpl(MetaDataPKFactory.getMetaDataPK(info.getFullName()), info.getBOSType());
            h.initHandle(r);
            cache.put(key, h);
            return h;
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }
}

